/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.choice;

import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.globusltd.recyclerview.choice.ObservableChoiceMode;
import com.globusltd.recyclerview.choice.SimpleChoiceModeListener;

@MainThread
public class SingleChoiceMode
extends ObservableChoiceMode {
    private static final String KEY_SINGLE_CHOICE_MODE = "single_choice_mode";
    private static final String KEY_CHECKED_ID = "checked_id";
    @Nullable
    private SimpleChoiceModeListener mChoiceModeListener;
    private long mCheckedId = -1L;

    public SingleChoiceMode() {
        this(null);
    }

    public SingleChoiceMode(@Nullable Bundle savedInstanceState) {
        Bundle state;
        Bundle bundle = state = savedInstanceState != null ? savedInstanceState.getBundle(KEY_SINGLE_CHOICE_MODE) : null;
        if (state != null) {
            this.mCheckedId = state.getLong(KEY_CHECKED_ID, -1L);
        }
    }

    public void setChoiceModeListener(@Nullable SimpleChoiceModeListener listener) {
        this.mChoiceModeListener = listener;
    }

    @Override
    public boolean requiresStableIds() {
        return true;
    }

    @Override
    public boolean requiresLongpress() {
        return false;
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    @IntRange(from=0L, to=1L)
    public int getCheckedItemCount() {
        return this.mCheckedId != -1L ? 1 : 0;
    }

    @Override
    public boolean isItemChecked(long itemId) {
        return this.mCheckedId == itemId;
    }

    @Override
    public void setItemChecked(long itemId, boolean checked) {
        this.setItemCheckedInternal(itemId, checked, false);
    }

    private void setItemCheckedInternal(long itemId, boolean checked, boolean fromUser) {
        long checkedId = this.mCheckedId;
        long l = this.mCheckedId = checked ? itemId : -1L;
        if (this.mChoiceModeListener != null) {
            this.mChoiceModeListener.onItemCheckedStateChanged(itemId, checked, fromUser);
        }
        this.notifyItemCheckedChanged(checkedId, fromUser);
        this.notifyItemCheckedChanged(this.mCheckedId, fromUser);
    }

    public long getCheckedItem() {
        return this.mCheckedId;
    }

    @Override
    public void clearChoices() {
        long itemId = this.mCheckedId;
        this.mCheckedId = -1L;
        this.notifyItemCheckedChanged(itemId, false);
    }

    @Override
    public boolean onClick(long itemId) {
        if (!this.isItemChecked(itemId)) {
            this.setItemCheckedInternal(itemId, true, true);
        }
        return true;
    }

    @Override
    public boolean onLongClick(long itemId) {
        return true;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        Bundle state = new Bundle();
        state.putLong(KEY_CHECKED_ID, this.mCheckedId);
        outState.putBundle(KEY_SINGLE_CHOICE_MODE, state);
    }
}

