/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.choice;

import android.os.Bundle;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import com.globusltd.recyclerview.choice.ActionModeCompat;
import com.globusltd.recyclerview.choice.ChoiceModeObserver;
import com.globusltd.recyclerview.choice.ModalChoiceModeListener;
import com.globusltd.recyclerview.choice.ObservableChoiceMode;

public class SingleModalChoiceMode
extends ObservableChoiceMode {
    private static final String KEY_SINGLE_MODAL_CHOICE_MODE = "single_modal_choice_mode";
    private static final String KEY_CHECKED_ID = "checked_id";
    @NonNull
    private final ActionModeCompat mActionModeCompat;
    @NonNull
    private final ActionModeCallbacks mActionModeCallbacks;
    private boolean mStartOnSingleTapEnabled = false;
    private boolean mFinishActionModeOnClearEnabled = true;
    @Nullable
    private ActionMode mActionMode;
    private long mCheckedId = -1L;

    public SingleModalChoiceMode(@NonNull ActionModeCompat actionModeCompat, @NonNull ModalChoiceModeListener listener) {
        this(actionModeCompat, listener, null);
    }

    public SingleModalChoiceMode(@NonNull ActionModeCompat actionModeCompat, @NonNull ModalChoiceModeListener listener, @Nullable Bundle savedInstanceState) {
        Bundle state;
        this.mActionModeCompat = actionModeCompat;
        this.mActionModeCallbacks = new ActionModeCallbacks(listener);
        Bundle bundle = state = savedInstanceState != null ? savedInstanceState.getBundle(KEY_SINGLE_MODAL_CHOICE_MODE) : null;
        if (state != null) {
            this.mCheckedId = state.getLong(KEY_CHECKED_ID, -1L);
        }
    }

    public void setStartOnSingleTapEnabled(boolean enabled) {
        this.mStartOnSingleTapEnabled = enabled;
    }

    public void setFinishActionModeOnClearEnabled(boolean enabled) {
        this.mFinishActionModeOnClearEnabled = enabled;
    }

    @Override
    public boolean requiresStableIds() {
        return true;
    }

    @Override
    public boolean requiresLongpress() {
        return true;
    }

    @Override
    public boolean isActivated() {
        return this.mActionMode != null;
    }

    @Override
    @IntRange(from=0L, to=1L)
    public int getCheckedItemCount() {
        return this.mCheckedId != -1L ? 1 : 0;
    }

    @Override
    public boolean isItemChecked(long itemId) {
        return this.mCheckedId == itemId;
    }

    @Override
    public void setItemChecked(long itemId, boolean checked) {
        this.setItemCheckedInternal(itemId, checked, false);
    }

    private void setItemCheckedInternal(long itemId, boolean checked, boolean fromUser) {
        if (checked) {
            this.startActionMode(fromUser);
        }
        long checkedId = this.mCheckedId;
        long l = this.mCheckedId = checked ? itemId : -1L;
        if (this.mActionMode != null) {
            this.mActionModeCallbacks.onItemCheckedStateChanged(this.mActionMode, itemId, checked, fromUser);
        }
        this.notifyItemCheckedChanged(checkedId, fromUser);
        this.notifyItemCheckedChanged(this.mCheckedId, fromUser);
    }

    public long getCheckedItem() {
        return this.mCheckedId;
    }

    @Override
    public void clearChoices() {
        this.clearChoicesInternal(false);
    }

    private void clearChoicesInternal(boolean fromDestroyCallback) {
        long itemId = this.mCheckedId;
        this.mCheckedId = -1L;
        this.notifyItemCheckedChanged(itemId, false);
        if (!fromDestroyCallback && this.mActionMode != null) {
            if (this.mFinishActionModeOnClearEnabled) {
                this.mActionMode.finish();
            } else {
                this.mActionMode.invalidate();
            }
        }
    }

    @Override
    public boolean onClick(long itemId) {
        if (this.mActionMode == null && this.mStartOnSingleTapEnabled) {
            this.setItemCheckedInternal(itemId, true, true);
            return true;
        }
        if (this.mActionMode != null) {
            boolean checked = !this.isItemChecked(itemId);
            this.setItemCheckedInternal(itemId, checked, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onLongClick(long itemId) {
        this.setItemCheckedInternal(itemId, true, true);
        return true;
    }

    @Override
    public void registerChoiceModeObserver(@NonNull ChoiceModeObserver observer) {
        super.registerChoiceModeObserver(observer);
        if (this.mCheckedId != -1L) {
            this.startActionMode(false);
        }
    }

    private void startActionMode(boolean fromUser) {
        if (this.mActionMode == null) {
            this.mActionMode = this.mActionModeCompat.startActionMode(this.mActionModeCallbacks);
            this.notifyAllItemsCheckedChanged(fromUser);
        }
    }

    @Override
    public void unregisterChoiceModeObserver(@NonNull ChoiceModeObserver observer) {
        super.unregisterChoiceModeObserver(observer);
        this.finishActionMode();
    }

    public void finish() {
        this.clearChoicesInternal(true);
        this.finishActionMode();
    }

    private void finishActionMode() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        Bundle state = new Bundle();
        state.putLong(KEY_CHECKED_ID, this.mCheckedId);
        outState.putBundle(KEY_SINGLE_MODAL_CHOICE_MODE, state);
    }

    private class ActionModeCallbacks
    implements ModalChoiceModeListener {
        private boolean mFinishFromUser;
        @NonNull
        private ModalChoiceModeListener mModalChoiceModeListener;

        private ActionModeCallbacks(ModalChoiceModeListener listener) {
            this.mModalChoiceModeListener = listener;
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            return this.mModalChoiceModeListener.onCreateActionMode(mode, menu);
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mModalChoiceModeListener.onPrepareActionMode(mode, menu);
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mModalChoiceModeListener.onActionItemClicked(mode, item);
        }

        public void onDestroyActionMode(ActionMode mode) {
            SingleModalChoiceMode.this.clearChoicesInternal(true);
            this.mModalChoiceModeListener.onDestroyActionMode(mode);
            SingleModalChoiceMode.this.mActionMode = null;
            SingleModalChoiceMode.this.notifyAllItemsCheckedChanged(this.mFinishFromUser);
            this.mFinishFromUser = false;
        }

        @Override
        public void onItemCheckedStateChanged(@NonNull ActionMode mode, long itemId, boolean checked, boolean fromUser) {
            mode.invalidate();
            this.mModalChoiceModeListener.onItemCheckedStateChanged(mode, itemId, checked, fromUser);
            if (SingleModalChoiceMode.this.mFinishActionModeOnClearEnabled && SingleModalChoiceMode.this.getCheckedItemCount() == 0) {
                this.mFinishFromUser = true;
                mode.finish();
            }
        }
    }
}

