/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.database.Cursor;
import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceObserver;
import java.io.Closeable;

@MainThread
public class CursorDatasource
implements Datasource<Cursor>,
Closeable {
    @Nullable
    private final Cursor mCursor;

    public CursorDatasource(@Nullable Cursor cursor) {
        this.mCursor = cursor;
    }

    @Override
    @NonNull
    public Cursor get(@IntRange(from=0L) int position) {
        if (this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        throw new IndexOutOfBoundsException("The underlying cursor is null");
    }

    @Override
    public int size() {
        return this.mCursor != null ? this.mCursor.getCount() : 0;
    }

    @Override
    public void close() {
        if (this.mCursor != null) {
            this.mCursor.close();
        }
    }

    @Override
    public void registerDatasourceObserver(@NonNull DatasourceObserver observer) {
    }

    @Override
    public void unregisterDatasourceObserver(@NonNull DatasourceObserver observer) {
    }
}

