/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import com.globusltd.recyclerview.datasource.DatasourceObserver;
import com.globusltd.recyclerview.util.Observable;

@MainThread
public class DatasourceObservable
extends Observable<DatasourceObserver> {
    public void notifyChanged() {
        int size = this.mObservers.size();
        for (int i = size - 1; i >= 0; --i) {
            ((DatasourceObserver)this.mObservers.get(i)).onChanged();
        }
    }

    public void notifyItemRangeChanged(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
        int size = this.mObservers.size();
        for (int i = size - 1; i >= 0; --i) {
            ((DatasourceObserver)this.mObservers.get(i)).onItemRangeChanged(positionStart, itemCount, payload);
        }
    }

    public void notifyItemRangeInserted(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        int size = this.mObservers.size();
        for (int i = size - 1; i >= 0; --i) {
            ((DatasourceObserver)this.mObservers.get(i)).onItemRangeInserted(positionStart, itemCount);
        }
    }

    public void notifyItemRangeRemoved(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        int size = this.mObservers.size();
        for (int i = size - 1; i >= 0; --i) {
            ((DatasourceObserver)this.mObservers.get(i)).onItemRangeRemoved(positionStart, itemCount);
        }
    }

    public void notifyItemMoved(@IntRange(from=0L) int fromPosition, @IntRange(from=0L) int toPosition) {
        int size = this.mObservers.size();
        for (int i = size - 1; i >= 0; --i) {
            ((DatasourceObserver)this.mObservers.get(i)).onItemMoved(fromPosition, toPosition);
        }
    }
}

