/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArraySet;
import android.support.v7.widget.RecyclerView;
import com.globusltd.recyclerview.DatasourceSwappable;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceObserver;
import com.globusltd.recyclerview.datasource.DatasourceProxy;
import java.util.Set;

@MainThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DatasourceOwner<E>
implements DatasourceSwappable<E> {
    @NonNull
    private final DatasourceProxy<E> mDatasource;
    @NonNull
    private final DatasourceObserver mDatasourceObserver;
    @NonNull
    private final Set<RecyclerView> mAttachedRecyclerViews;

    public DatasourceOwner(@NonNull DatasourceProxy<E> datasource, @NonNull DatasourceObserver datasourceObserver) {
        this.mDatasource = datasource;
        this.mDatasourceObserver = datasourceObserver;
        this.mAttachedRecyclerViews = new ArraySet();
    }

    @NonNull
    public Datasource<? extends E> getDatasource() {
        return this.mDatasource;
    }

    @Override
    @Nullable
    public Datasource<? extends E> swap(@NonNull Datasource<? extends E> datasource) {
        return this.mDatasource.swap(datasource);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        if (this.mAttachedRecyclerViews.isEmpty() && this.mAttachedRecyclerViews.add(recyclerView)) {
            this.mDatasource.registerDatasourceObserver(this.mDatasourceObserver);
        } else {
            this.mAttachedRecyclerViews.add(recyclerView);
        }
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.mAttachedRecyclerViews.remove(recyclerView) && this.mAttachedRecyclerViews.isEmpty()) {
            this.mDatasource.unregisterDatasourceObserver(this.mDatasourceObserver);
        }
    }
}

