/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.globusltd.recyclerview.DatasourceSwappable;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceObservable;
import com.globusltd.recyclerview.datasource.DatasourceObserver;
import com.globusltd.recyclerview.diff.DiffCallback;
import com.globusltd.recyclerview.diff.DiffCallbackFactory;

@MainThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DatasourceProxy<E>
implements Datasource<E>,
DatasourceSwappable<E> {
    @Nullable
    private final DiffCallbackFactory<E> mDiffCallbackFactory;
    @NonNull
    private final DatasourceObservable mDatasourceObservable;
    @NonNull
    private final DatasourceObserver mDatasourceObserver;
    @NonNull
    private final ListUpdateCallback mListUpdateCallback;
    @NonNull
    private Datasource<? extends E> mDatasource;

    public DatasourceProxy(@NonNull Datasource<? extends E> datasource, @Nullable DiffCallbackFactory<E> diffCallbackFactory) {
        this.mDatasource = datasource;
        this.mDiffCallbackFactory = diffCallbackFactory;
        this.mDatasourceObservable = new DatasourceObservable();
        this.mDatasourceObserver = new DatasourceObserverProxy();
        this.mListUpdateCallback = new DatasourceListUpdateCallback();
        this.mDatasource.registerDatasourceObserver(this.mDatasourceObserver);
    }

    @Override
    @Nullable
    public Datasource<? extends E> swap(@NonNull Datasource<? extends E> datasource) {
        Datasource<E> oldDatasource = this.mDatasource;
        oldDatasource.unregisterDatasourceObserver(this.mDatasourceObserver);
        int itemCount = datasource.size();
        if (oldDatasource.size() == 0) {
            this.mDatasource = datasource;
            this.mDatasource.registerDatasourceObserver(this.mDatasourceObserver);
            this.mDatasourceObservable.notifyItemRangeInserted(0, itemCount);
        } else if (this.mDiffCallbackFactory != null) {
            DiffCallback diffCallback = this.mDiffCallbackFactory.createDiffCallback(oldDatasource, datasource);
            this.mDatasource = datasource;
            this.mDatasource.registerDatasourceObserver(this.mDatasourceObserver);
            DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback, (boolean)diffCallback.shouldDetectMoves()).dispatchUpdatesTo(this.mListUpdateCallback);
        } else {
            this.mDatasource = datasource;
            this.mDatasource.registerDatasourceObserver(this.mDatasourceObserver);
            this.mDatasourceObservable.notifyItemRangeChanged(0, itemCount, null);
        }
        return oldDatasource;
    }

    @Override
    @NonNull
    public E get(@IntRange(from=0L) int position) {
        return this.mDatasource.get(position);
    }

    @Override
    public int size() {
        return this.mDatasource.size();
    }

    @Override
    public void registerDatasourceObserver(@NonNull DatasourceObserver observer) {
        this.mDatasourceObservable.registerObserver(observer);
    }

    @Override
    public void unregisterDatasourceObserver(@NonNull DatasourceObserver observer) {
        this.mDatasourceObservable.unregisterObserver(observer);
    }

    private class DatasourceListUpdateCallback
    implements ListUpdateCallback {
        private DatasourceListUpdateCallback() {
        }

        public void onInserted(int position, int count) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeInserted(position, count);
        }

        public void onRemoved(int position, int count) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeRemoved(position, count);
        }

        public void onMoved(int fromPosition, int toPosition) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemMoved(fromPosition, toPosition);
        }

        public void onChanged(int position, int count, Object payload) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeChanged(position, count, payload);
        }
    }

    private class DatasourceObserverProxy
    extends DatasourceObserver {
        private DatasourceObserverProxy() {
        }

        @Override
        public void onChanged() {
            DatasourceProxy.this.mDatasourceObservable.notifyChanged();
        }

        @Override
        public void onItemRangeChanged(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        @Override
        public void onItemRangeInserted(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeInserted(positionStart, itemCount);
        }

        @Override
        public void onItemRangeRemoved(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemRangeRemoved(positionStart, itemCount);
        }

        @Override
        public void onItemMoved(@IntRange(from=0L) int fromPosition, @IntRange(from=0L) int toPosition) {
            DatasourceProxy.this.mDatasourceObservable.notifyItemMoved(fromPosition, toPosition);
        }
    }
}

