/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceObserver;

public class Datasources {
    private static final Datasource EMPTY_DATASOURCE = new EmptyDatasource();

    public static <T> Datasource<? extends T> empty() {
        return EMPTY_DATASOURCE;
    }

    private Datasources() {
    }

    private static class EmptyDatasource<E>
    implements Datasource<E> {
        private EmptyDatasource() {
        }

        @Override
        @NonNull
        public E get(@IntRange(from=0L) int position) {
            throw new IndexOutOfBoundsException("Datasource has no element at position=" + position);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void registerDatasourceObserver(@NonNull DatasourceObserver observer) {
        }

        @Override
        public void unregisterDatasourceObserver(@NonNull DatasourceObserver observer) {
        }
    }
}

