/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.datasource;

import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.datasource.DatasourceObservable;
import com.globusltd.recyclerview.datasource.DatasourceObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@MainThread
public class ListDatasource<E>
implements Datasource<E> {
    @NonNull
    private final List<E> mItems;
    @NonNull
    private final DatasourceObservable mDatasourceObservable;

    public ListDatasource() {
        this(Collections.emptyList());
    }

    public ListDatasource(@NonNull List<? extends E> items) {
        this.mItems = new ArrayList<E>(items);
        this.mDatasourceObservable = new DatasourceObservable();
    }

    @Override
    @NonNull
    public E get(@IntRange(from=0L) int position) {
        return this.mItems.get(position);
    }

    public void add(@NonNull E e) {
        if (this.mItems.add(e)) {
            int position = this.mItems.size() - 1;
            this.mDatasourceObservable.notifyItemRangeInserted(position, 1);
        }
    }

    public void add(@IntRange(from=0L) int position, @NonNull E e) {
        this.mItems.add(position, e);
        this.mDatasourceObservable.notifyItemRangeInserted(position, 1);
    }

    public void addAll(@NonNull List<? extends E> items) {
        int positionStart = this.mItems.size();
        if (this.mItems.addAll(items)) {
            int itemCount = items.size();
            this.mDatasourceObservable.notifyItemRangeInserted(positionStart, itemCount);
        }
    }

    public void addAll(@IntRange(from=0L) int position, @NonNull List<? extends E> items) {
        if (this.mItems.addAll(position, items)) {
            int itemCount = items.size();
            this.mDatasourceObservable.notifyItemRangeInserted(position, itemCount);
        }
    }

    public void move(@IntRange(from=0L) int fromPosition, @IntRange(from=0L) int toPosition) {
        E e = this.mItems.remove(fromPosition);
        this.mItems.add(toPosition, e);
        this.mDatasourceObservable.notifyItemMoved(fromPosition, toPosition);
    }

    @NonNull
    public E set(@IntRange(from=0L) int position, @NonNull E item) {
        E e = this.mItems.set(position, item);
        this.mDatasourceObservable.notifyItemRangeChanged(position, 1, null);
        return e;
    }

    @NonNull
    public E remove(@IntRange(from=0L) int position) {
        E e = this.mItems.remove(position);
        this.mDatasourceObservable.notifyItemRangeRemoved(position, 1);
        return e;
    }

    public void removeRange(@IntRange(from=0L) int fromPosition, @IntRange(from=1L) int itemCount) {
        for (int position = fromPosition + itemCount - 1; position >= fromPosition; --position) {
            this.mItems.remove(position);
        }
        this.mDatasourceObservable.notifyItemRangeRemoved(fromPosition, itemCount);
    }

    public void clear() {
        int itemCount = this.mItems.size();
        this.mItems.clear();
        this.mDatasourceObservable.notifyItemRangeRemoved(0, itemCount);
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public void registerDatasourceObserver(@NonNull DatasourceObserver observer) {
        this.mDatasourceObservable.registerObserver(observer);
    }

    @Override
    public void unregisterDatasourceObserver(@NonNull DatasourceObserver observer) {
        this.mDatasourceObservable.unregisterObserver(observer);
    }
}

