/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.diff;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.globusltd.recyclerview.datasource.Datasource;
import com.globusltd.recyclerview.diff.DiffCallback;
import com.globusltd.recyclerview.diff.ParameterizedDiffCallback;

public abstract class SimpleDatasourcesDiffCallback<E>
extends DiffCallback
implements ParameterizedDiffCallback<E> {
    @NonNull
    private final Datasource<? extends E> mOldDatasource;
    @NonNull
    private final Datasource<? extends E> mNewDatasource;

    public SimpleDatasourcesDiffCallback(@NonNull Datasource<? extends E> oldDatasource, @NonNull Datasource<? extends E> newDatasource) {
        this(oldDatasource, newDatasource, true);
    }

    public SimpleDatasourcesDiffCallback(@NonNull Datasource<? extends E> oldDatasource, @NonNull Datasource<? extends E> newDatasource, boolean shouldDetectMoves) {
        super(shouldDetectMoves);
        this.mOldDatasource = oldDatasource;
        this.mNewDatasource = newDatasource;
    }

    public int getOldListSize() {
        return this.mOldDatasource.size();
    }

    public int getNewListSize() {
        return this.mNewDatasource.size();
    }

    @Override
    public final boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areItemsTheSame(this.mOldDatasource.get(oldItemPosition), this.mNewDatasource.get(newItemPosition));
    }

    @Override
    public final boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return this.areContentsTheSame(this.mOldDatasource.get(oldItemPosition), this.mNewDatasource.get(newItemPosition));
    }

    @Override
    @Nullable
    public final Object getChangePayload(int oldItemPosition, int newItemPosition) {
        return this.getChangePayload(this.mOldDatasource.get(oldItemPosition), this.mNewDatasource.get(newItemPosition));
    }

    @Override
    @Nullable
    public Object getChangePayload(@NonNull E oldItem, @NonNull E newItem) {
        return null;
    }
}

