/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.lifecycle;

import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.SparseBooleanArray;
import com.globusltd.recyclerview.ViewHolderObserver;
import com.globusltd.recyclerview.lifecycle.LifecycleCallbacks;
import com.globusltd.recyclerview.lifecycle.LifecycleComposite;

@MainThread
public class LifecycleBehavior
implements ViewHolderObserver {
    @NonNull
    private final LifecycleComposite mLifecycleComposite;
    @NonNull
    private final SparseBooleanArray mLifecycleCallbacksTypes;

    public LifecycleBehavior(@NonNull LifecycleComposite lifecycleComposite) {
        this.mLifecycleComposite = lifecycleComposite;
        this.mLifecycleCallbacksTypes = new SparseBooleanArray();
    }

    @Override
    public void onAttached(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isLifecycleCallbacks(viewHolder)) {
            LifecycleCallbacks lifecycleCallbacks = (LifecycleCallbacks)viewHolder;
            this.mLifecycleComposite.registerLifecycleCallbacks(lifecycleCallbacks);
        }
    }

    @Override
    public void onPositionChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
    }

    @Override
    public void onChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isLifecycleCallbacks(viewHolder)) {
            LifecycleCallbacks lifecycleCallbacks = (LifecycleCallbacks)viewHolder;
            this.mLifecycleComposite.unregisterLifecycleCallbacks(lifecycleCallbacks);
            this.mLifecycleComposite.registerLifecycleCallbacks(lifecycleCallbacks);
        }
    }

    @Override
    public void onDetached(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isLifecycleCallbacks(viewHolder)) {
            LifecycleCallbacks lifecycleCallbacks = (LifecycleCallbacks)viewHolder;
            this.mLifecycleComposite.unregisterLifecycleCallbacks(lifecycleCallbacks);
        }
    }

    private boolean isLifecycleCallbacks(@NonNull RecyclerView.ViewHolder viewHolder) {
        int viewType = viewHolder.getItemViewType();
        if (this.mLifecycleCallbacksTypes.indexOfKey(viewType) >= 0) {
            return this.mLifecycleCallbacksTypes.get(viewType);
        }
        boolean isLifecycleCallbacks = LifecycleCallbacks.class.isInstance(viewHolder);
        this.mLifecycleCallbacksTypes.put(viewType, isLifecycleCallbacks);
        return isLifecycleCallbacks;
    }
}

