/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.lifecycle;

import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import com.globusltd.recyclerview.lifecycle.LifecycleCallbacks;
import java.util.LinkedHashMap;
import java.util.Map;

@MainThread
public class LifecycleComposite
implements LifecycleCallbacks {
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int RESUMED = 2;
    private int mLifecycleState = 0;
    @NonNull
    private final Map<LifecycleCallbacks, Integer> mLifecycleCallbacks = new LinkedHashMap<LifecycleCallbacks, Integer>();

    public void registerLifecycleCallbacks(@NonNull LifecycleCallbacks lifecycleCallbacks) {
        if (!this.mLifecycleCallbacks.containsKey(lifecycleCallbacks)) {
            int lifecycleState = 0;
            if ((this.mLifecycleState & 1) == 1) {
                lifecycleCallbacks.onStart();
                lifecycleState |= 1;
            }
            if ((this.mLifecycleState & 2) == 2) {
                lifecycleCallbacks.onResume();
                lifecycleState |= 2;
            }
            this.mLifecycleCallbacks.put(lifecycleCallbacks, lifecycleState);
        }
    }

    public void unregisterLifecycleCallbacks(@NonNull LifecycleCallbacks lifecycleCallbacks) {
        if (this.mLifecycleCallbacks.containsKey(lifecycleCallbacks)) {
            int lifecycleState = this.mLifecycleCallbacks.remove(lifecycleCallbacks);
            if ((lifecycleState & 2) == 2) {
                lifecycleCallbacks.onPause();
            }
            if ((lifecycleState & 1) == 1) {
                lifecycleCallbacks.onStop();
            }
        }
    }

    @Override
    public void onStart() {
        this.mLifecycleState |= 1;
        for (Map.Entry<LifecycleCallbacks, Integer> entry : this.mLifecycleCallbacks.entrySet()) {
            int lifecycleState = entry.getValue();
            if ((lifecycleState & 1) == 1) continue;
            LifecycleCallbacks lifecycleCallbacks = entry.getKey();
            lifecycleCallbacks.onStart();
            entry.setValue(lifecycleState | 1);
        }
    }

    @Override
    public void onResume() {
        this.mLifecycleState |= 2;
        for (Map.Entry<LifecycleCallbacks, Integer> entry : this.mLifecycleCallbacks.entrySet()) {
            int lifecycleState = entry.getValue();
            if ((lifecycleState & 2) == 2) continue;
            LifecycleCallbacks lifecycleCallbacks = entry.getKey();
            lifecycleCallbacks.onResume();
            entry.setValue(lifecycleState | 2);
        }
    }

    @Override
    public void onPause() {
        this.mLifecycleState &= 0xFFFFFFFD;
        for (Map.Entry<LifecycleCallbacks, Integer> entry : this.mLifecycleCallbacks.entrySet()) {
            int lifecycleState = entry.getValue();
            if ((lifecycleState & 2) != 2) continue;
            LifecycleCallbacks lifecycleCallbacks = entry.getKey();
            lifecycleCallbacks.onPause();
            entry.setValue(lifecycleState & 0xFFFFFFFD);
        }
    }

    @Override
    public void onStop() {
        this.mLifecycleState &= 0xFFFFFFFE;
        for (Map.Entry<LifecycleCallbacks, Integer> entry : this.mLifecycleCallbacks.entrySet()) {
            int lifecycleState = entry.getValue();
            if ((lifecycleState & 1) != 1) continue;
            LifecycleCallbacks lifecycleCallbacks = entry.getKey();
            lifecycleCallbacks.onStop();
            entry.setValue(lifecycleState & 0xFFFFFFFE);
        }
    }
}

