/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.util;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public abstract class Observable<T> {
    @NonNull
    protected final List<T> mObservers = new ArrayList<T>();

    public boolean hasObservers() {
        return !this.mObservers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(@NonNull T observer) {
        List<T> list = this.mObservers;
        synchronized (list) {
            if (!this.mObservers.contains(observer)) {
                this.mObservers.add(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObserver(@NonNull T observer) {
        List<T> list = this.mObservers;
        synchronized (list) {
            int index = this.mObservers.indexOf(observer);
            if (index > -1) {
                this.mObservers.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        List<T> list = this.mObservers;
        synchronized (list) {
            this.mObservers.clear();
        }
    }
}

