/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.SparseBooleanArray;
import android.view.View;
import android.widget.Checkable;
import com.globusltd.recyclerview.ViewHolderObserver;
import com.globusltd.recyclerview.ViewHolderTracker;
import com.globusltd.recyclerview.choice.CheckableViewHolder;
import com.globusltd.recyclerview.choice.ChoiceMode;
import com.globusltd.recyclerview.choice.ChoiceModeObserver;
import com.globusltd.recyclerview.choice.NoneChoiceMode;
import com.globusltd.recyclerview.view.ItemClickHelper;

@MainThread
public class ChoiceModeHelper<E>
extends ItemClickHelper<E> {
    private static final ChoiceMode DEFAULT_CHOICE_MODE = new NoneChoiceMode();
    @NonNull
    private ChoiceMode mChoiceMode;
    @NonNull
    private final ChoiceModeObserver mChoiceModeObserver;
    @NonNull
    private final SparseBooleanArray mCheckableViewTypes;
    @NonNull
    private final SparseBooleanArray mCheckableViewHolderTypes;
    @NonNull
    private final ViewHolderTracker mViewHolderTracker;
    @NonNull
    private final ViewHolderObserver mViewHolderObserver;

    public ChoiceModeHelper(@NonNull ItemClickHelper.Callback<E> callback) {
        this(callback, DEFAULT_CHOICE_MODE);
    }

    public ChoiceModeHelper(@NonNull ItemClickHelper.Callback<E> callback, @NonNull ChoiceMode choiceMode) {
        super(callback);
        this.mChoiceMode = choiceMode;
        this.mChoiceModeObserver = new ChoiceModeObserverImpl();
        this.mCheckableViewTypes = new SparseBooleanArray();
        this.mCheckableViewHolderTypes = new SparseBooleanArray();
        this.mViewHolderTracker = new ViewHolderTracker();
        this.mViewHolderObserver = new ChoiceModeViewHolderObserver();
    }

    public void setChoiceMode(@NonNull ChoiceMode choiceMode) {
        this.mChoiceMode.unregisterChoiceModeObserver(this.mChoiceModeObserver);
        this.mChoiceMode = choiceMode;
        RecyclerView recyclerView = this.getRecyclerView();
        if (recyclerView != null) {
            this.checkIfAdapterCompatibleToChoiceModeOrThrow(recyclerView, this.mChoiceMode);
            this.notifyLongpressEnabledChanged();
            this.mChoiceMode.registerChoiceModeObserver(this.mChoiceModeObserver);
            this.mChoiceModeObserver.notifyAllItemsCheckedChanged(false);
        }
    }

    @Override
    protected void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.checkIfAdapterCompatibleToChoiceModeOrThrow(recyclerView, this.mChoiceMode);
        this.mChoiceMode.registerChoiceModeObserver(this.mChoiceModeObserver);
        this.mViewHolderTracker.registerViewHolderObserver(this.mViewHolderObserver);
        this.mViewHolderTracker.setRecyclerView(recyclerView);
    }

    private void checkIfAdapterCompatibleToChoiceModeOrThrow(@NonNull RecyclerView recyclerView, @NonNull ChoiceMode choiceMode) {
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter == null) {
            throw new IllegalStateException("Call RecyclerView#setAdapter with non-null argument before calling ChoiceModeHepler#setChoiceMode");
        }
        if (!adapter.hasStableIds() && choiceMode.requiresStableIds()) {
            throw new IllegalStateException("RecyclerView.Adapter should have stable ids");
        }
    }

    @Override
    protected void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mCheckableViewTypes.clear();
        this.mCheckableViewHolderTypes.clear();
        this.mChoiceMode.unregisterChoiceModeObserver(this.mChoiceModeObserver);
        this.mViewHolderTracker.unregisterViewHolderObserver(this.mViewHolderObserver);
        this.mViewHolderTracker.setRecyclerView(null);
    }

    @Override
    protected boolean isLongPressEnabled() {
        return this.mChoiceMode.requiresLongpress() || super.isLongPressEnabled();
    }

    @Override
    protected boolean performClick(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
        boolean isItemViewClicked = viewHolder.itemView == view;
        return isItemViewClicked && this.mChoiceMode.onClick(viewHolder.getItemId()) || super.performClick(viewHolder, view);
    }

    @Override
    protected boolean performLongPress(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
        boolean isItemViewClicked = viewHolder.itemView == view;
        return isItemViewClicked && this.mChoiceMode.onLongClick(viewHolder.getItemId()) || super.performLongPress(viewHolder, view);
    }

    private void onViewHolderCheckedChanged(@NonNull RecyclerView.ViewHolder viewHolder, boolean fromUser) {
        boolean isActivated = this.mChoiceMode.isActivated();
        long itemId = viewHolder.getItemId();
        boolean isChecked = this.mChoiceMode.isItemChecked(itemId);
        this.setViewHolderChecked(viewHolder, isChecked);
        this.updateCheckableViewHolder(viewHolder, isActivated, isChecked, fromUser);
    }

    @TargetApi(value=11)
    private void setViewHolderChecked(@NonNull RecyclerView.ViewHolder viewHolder, boolean isChecked) {
        View itemView = viewHolder.itemView;
        if (this.isCheckableView(viewHolder)) {
            ((Checkable)itemView).setChecked(isChecked);
        } else if (this.shouldUseActivated(viewHolder)) {
            itemView.setActivated(isChecked);
        }
    }

    private boolean isCheckableView(@NonNull RecyclerView.ViewHolder viewHolder) {
        int viewType = viewHolder.getItemViewType();
        if (this.mCheckableViewTypes.indexOfKey(viewType) >= 0) {
            return this.mCheckableViewTypes.get(viewType);
        }
        boolean isCheckable = Checkable.class.isInstance(viewHolder.itemView);
        this.mCheckableViewTypes.put(viewType, isCheckable);
        return isCheckable;
    }

    private boolean shouldUseActivated(@NonNull RecyclerView.ViewHolder viewHolder) {
        Context context = viewHolder.itemView.getContext();
        int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
        return targetSdkVersion >= 11;
    }

    private void updateCheckableViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, boolean isActivated, boolean isChecked, boolean fromUser) {
        if (this.isCheckableViewHolder(viewHolder)) {
            CheckableViewHolder checkableViewHolder = (CheckableViewHolder)viewHolder;
            checkableViewHolder.setInChoiceMode(isActivated);
            checkableViewHolder.setChecked(isChecked, fromUser);
        }
    }

    private boolean isCheckableViewHolder(@NonNull RecyclerView.ViewHolder viewHolder) {
        int viewType = viewHolder.getItemViewType();
        if (this.mCheckableViewHolderTypes.indexOfKey(viewType) >= 0) {
            return this.mCheckableViewHolderTypes.get(viewType);
        }
        boolean isCheckable = CheckableViewHolder.class.isInstance(viewHolder);
        this.mCheckableViewHolderTypes.put(viewType, isCheckable);
        return isCheckable;
    }

    private class ChoiceModeObserverImpl
    extends ChoiceModeObserver {
        private ChoiceModeObserverImpl() {
        }

        @Override
        public void onItemCheckedChanged(long itemId, boolean fromUser) {
            RecyclerView.ViewHolder viewHolder;
            RecyclerView recyclerView = ChoiceModeHelper.this.getRecyclerView();
            RecyclerView.ViewHolder viewHolder2 = viewHolder = recyclerView != null ? recyclerView.findViewHolderForItemId(itemId) : null;
            if (viewHolder != null) {
                ChoiceModeHelper.this.onViewHolderCheckedChanged(viewHolder, fromUser);
            }
        }

        @Override
        public void notifyAllItemsCheckedChanged(boolean fromUser) {
            RecyclerView recyclerView = ChoiceModeHelper.this.getRecyclerView();
            int childCount = recyclerView != null ? recyclerView.getChildCount() : 0;
            for (int index = 0; index < childCount; ++index) {
                View itemView = recyclerView.getChildAt(index);
                RecyclerView.ViewHolder viewHolder = recyclerView.findContainingViewHolder(itemView);
                if (viewHolder == null) continue;
                ChoiceModeHelper.this.onViewHolderCheckedChanged(viewHolder, fromUser);
            }
        }
    }

    private class ChoiceModeViewHolderObserver
    implements ViewHolderObserver {
        private ChoiceModeViewHolderObserver() {
        }

        @Override
        public void onAttached(@NonNull RecyclerView.ViewHolder viewHolder) {
            ChoiceModeHelper.this.onViewHolderCheckedChanged(viewHolder, false);
        }

        @Override
        public void onPositionChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
            ChoiceModeHelper.this.onViewHolderCheckedChanged(viewHolder, false);
        }

        @Override
        public void onChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
            ChoiceModeHelper.this.onViewHolderCheckedChanged(viewHolder, false);
        }

        @Override
        public void onDetached(@NonNull RecyclerView.ViewHolder viewHolder) {
            ChoiceModeHelper.this.setViewHolderChecked(viewHolder, false);
            ChoiceModeHelper.this.updateCheckableViewHolder(viewHolder, false, false, false);
        }
    }
}

