/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.globusltd.recyclerview.view.ClickableViews;
import com.globusltd.recyclerview.view.ItemClickHelper;

@MainThread
class ClickableViewFinder {
    @NonNull
    private final RecyclerView mHostView;
    @NonNull
    private final ItemClickHelper.Callback<?> mCallback;

    ClickableViewFinder(@NonNull RecyclerView hostView, @NonNull ItemClickHelper.Callback<?> callback) {
        this.mHostView = hostView;
        this.mCallback = callback;
    }

    @Nullable
    Target findTarget(float x, float y) {
        View itemView = this.mHostView.findChildViewUnder(x, y);
        if (itemView == null) {
            return null;
        }
        RecyclerView.ViewHolder viewHolder = this.mHostView.getChildViewHolder(itemView);
        int position = viewHolder.getAdapterPosition();
        int viewType = viewHolder.getItemViewType();
        if (position <= -1 || viewType <= -1) {
            return null;
        }
        ClickableViews clickableViews = this.mCallback.getClickableViews(position, viewType);
        return this.findTargetInViewHolder(viewHolder, clickableViews, x, y);
    }

    @Nullable
    private Target findTargetInViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull ClickableViews clickableViews, float x, float y) {
        View itemView = viewHolder.itemView;
        int defaultViewId = clickableViews.getDefaultViewId();
        int[] clickableViewIds = clickableViews.getClickableViewIds();
        if (defaultViewId == -1 && clickableViewIds.length == 0) {
            return null;
        }
        if (defaultViewId == Integer.MIN_VALUE && clickableViewIds.length == 0) {
            return new Target(viewHolder, itemView);
        }
        View touchedView = this.findViewAt(itemView, x, y);
        View clickableView = touchedView != null ? this.findClickableViewUpward(touchedView, itemView, clickableViews) : null;
        return clickableView != null ? new Target(viewHolder, clickableView) : null;
    }

    @Nullable
    private View findViewAt(@NonNull View view, float x, float y) {
        if (!(view.isShown() && view.isEnabled() && this.isViewAt(view, x, y))) {
            return null;
        }
        if (view instanceof ViewGroup) {
            float transformedX = x - (float)view.getLeft() - ViewCompat.getTranslationX((View)view);
            float transformedY = y - (float)view.getTop() - ViewCompat.getTranslationY((View)view);
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = viewGroup.getChildAt(i);
                View foundView = this.findViewAt(child, transformedX, transformedY);
                if (foundView == null) continue;
                return foundView;
            }
        }
        return view;
    }

    private boolean isViewAt(@NonNull View view, float x, float y) {
        float viewX = (float)view.getLeft() - ViewCompat.getTranslationX((View)view);
        float viewY = (float)view.getTop() - ViewCompat.getTranslationY((View)view);
        return x > viewX && x < viewX + (float)view.getWidth() && y > viewY && y < viewY + (float)view.getHeight();
    }

    @Nullable
    private View findClickableViewUpward(@NonNull View view, @NonNull View itemView, @NonNull ClickableViews clickableViews) {
        View candidate = view;
        do {
            boolean isDefaultView;
            boolean bl = isDefaultView = candidate == itemView && clickableViews.getDefaultViewId() == Integer.MIN_VALUE;
            if (isDefaultView || this.isViewClickable(candidate, clickableViews)) {
                return candidate;
            }
            ViewParent parent = view.getParent();
            View view2 = candidate = parent instanceof View ? (View)parent : null;
        } while (candidate != null && candidate != itemView.getParent());
        return null;
    }

    private boolean isViewClickable(@NonNull View view, @NonNull ClickableViews clickableViews) {
        int[] clickableViewIds;
        int viewId = view.getId();
        if (clickableViews.getDefaultViewId() == viewId) {
            return true;
        }
        for (int id : clickableViewIds = clickableViews.getClickableViewIds()) {
            if (viewId != id) continue;
            return true;
        }
        return false;
    }

    static class Target {
        @NonNull
        private final RecyclerView.ViewHolder mViewHolder;
        @NonNull
        private final View mView;

        private Target(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
            this.mViewHolder = viewHolder;
            this.mView = view;
        }

        @NonNull
        RecyclerView.ViewHolder getViewHolder() {
            return this.mViewHolder;
        }

        @NonNull
        View getView() {
            return this.mView;
        }

        void setPressed(boolean pressed, float x, float y) {
            if (pressed && Build.VERSION.SDK_INT >= 21) {
                float hotspotX = x;
                float hotspotY = y;
                View view = this.mView;
                do {
                    hotspotX = hotspotX - (float)view.getLeft() - ViewCompat.getTranslationX((View)view);
                    hotspotY = hotspotY - (float)view.getTop() - ViewCompat.getTranslationY((View)view);
                    ViewParent parent = view.getParent();
                    View view2 = view = parent instanceof View ? (View)parent : null;
                } while (view != null && view != this.mViewHolder.itemView.getParent());
                this.mView.drawableHotspotChanged(hotspotX, hotspotY);
            }
            this.setPressed(pressed);
        }

        void setPressed(boolean pressed) {
            this.mView.setPressed(pressed);
        }
    }
}

