/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;

public final class EnchancedGestureDetector
implements GestureDetector.OnGestureListener {
    private static final int MIN_FLING_VELOCITY = 350;
    private static final float VELOCITY_REDUCE_FACTOR = 1.5f;
    @NonNull
    private final GestureDetectorCompat mGestureDetector;
    @NonNull
    private final OnGestureListener mListener;
    private boolean mAlwaysInTapRegion;
    private boolean mScrollInProgress = false;
    private boolean mHandleFling = false;
    @Nullable
    private MotionEvent mPreviousMotionEvent;

    public EnchancedGestureDetector(@NonNull Context context, @NonNull OnGestureListener listener) {
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this);
        this.mListener = listener;
    }

    public void setLongpressEnabled(boolean enabled) {
        this.mGestureDetector.setIsLongpressEnabled(enabled);
    }

    public boolean onTouchEvent(@NonNull MotionEvent e) {
        switch (e.getAction()) {
            case 1: 
            case 3: 
            case 4: {
                this.mScrollInProgress = false;
                boolean handled = this.mGestureDetector.onTouchEvent(e);
                this.mListener.onHidePress();
                if (!handled) {
                    this.mListener.onUp(e);
                }
                return handled;
            }
        }
        return this.mGestureDetector.onTouchEvent(e);
    }

    public boolean onDown(@NonNull MotionEvent e) {
        this.mAlwaysInTapRegion = true;
        this.mHandleFling = true;
        return this.mListener.onDown(e);
    }

    public boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
        this.mListener.onHidePress();
        this.mListener.onUp(e1);
        return this.mHandleFling && (Math.abs(velocityX) > 350.0f || Math.abs(velocityY) > 350.0f) && this.mListener.onFling(e1, e2, velocityX / 1.5f, velocityY / 1.5f);
    }

    public void onLongPress(@NonNull MotionEvent e) {
        this.mListener.onLongPress(e);
    }

    public boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
        if (!this.mScrollInProgress) {
            if (this.mAlwaysInTapRegion) {
                this.mListener.onHidePress();
            }
            this.mAlwaysInTapRegion = false;
            this.mScrollInProgress = this.mListener.onScrollBegin(e1);
            this.mPreviousMotionEvent = MotionEvent.obtain((MotionEvent)e1);
            return this.mScrollInProgress;
        }
        if (this.mPreviousMotionEvent != null) {
            boolean res = this.mListener.onScroll(e1, this.mPreviousMotionEvent, e2, distanceX, distanceY);
            this.mPreviousMotionEvent.recycle();
            this.mPreviousMotionEvent = MotionEvent.obtain((MotionEvent)e2);
            return res;
        }
        return false;
    }

    public void onShowPress(@NonNull MotionEvent e) {
        this.mListener.onShowPress(e);
    }

    public boolean onSingleTapUp(@NonNull MotionEvent e) {
        return this.mListener.onSingleTapUp(e);
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener {
        @Override
        public boolean onDown(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public void onShowPress(@NonNull MotionEvent e) {
        }

        @Override
        public boolean onSingleTapUp(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public void onLongPress(@NonNull MotionEvent e) {
        }

        @Override
        public boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        @Override
        public boolean onScrollBegin(@NonNull MotionEvent e) {
            return false;
        }

        @Override
        public boolean onScroll(@NonNull MotionEvent first, @NonNull MotionEvent previous, @NonNull MotionEvent current, float distanceX, float distanceY) {
            return false;
        }

        @Override
        public void onHidePress() {
        }

        @Override
        public void onUp(@NonNull MotionEvent e) {
        }
    }

    public static interface OnGestureListener {
        public boolean onDown(@NonNull MotionEvent var1);

        public void onShowPress(@NonNull MotionEvent var1);

        public boolean onSingleTapUp(@NonNull MotionEvent var1);

        public void onLongPress(@NonNull MotionEvent var1);

        public boolean onFling(@NonNull MotionEvent var1, @NonNull MotionEvent var2, float var3, float var4);

        public boolean onScrollBegin(@NonNull MotionEvent var1);

        public boolean onScroll(@NonNull MotionEvent var1, @NonNull MotionEvent var2, @NonNull MotionEvent var3, float var4, float var5);

        public void onHidePress();

        public void onUp(@NonNull MotionEvent var1);
    }
}

