/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.globusltd.recyclerview.RecyclerViewOwner;
import com.globusltd.recyclerview.view.ClickableViewFinder;
import com.globusltd.recyclerview.view.ClickableViews;
import com.globusltd.recyclerview.view.EnchancedGestureDetector;
import com.globusltd.recyclerview.view.OnItemClickListener;
import com.globusltd.recyclerview.view.OnItemLongClickListener;

@MainThread
public class ItemClickHelper<E>
extends RecyclerViewOwner {
    @NonNull
    private final Callback<E> mCallback;
    @NonNull
    private final RecyclerView.OnItemTouchListener mOnItemTouchListener;
    @Nullable
    private OnItemClickListener<E> mOnItemClickListener;
    @Nullable
    private OnItemLongClickListener<E> mOnItemLongClickListener;
    @Nullable
    private EnchancedGestureDetector mGestureDetector;

    public ItemClickHelper(@NonNull Callback<E> callback) {
        this.mCallback = callback;
        this.mOnItemTouchListener = new OnItemTouchListener();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<E> onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<E> onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
        this.notifyLongpressEnabledChanged();
    }

    protected boolean isLongPressEnabled() {
        return this.mOnItemClickListener != null;
    }

    protected void notifyLongpressEnabledChanged() {
        if (this.mGestureDetector != null) {
            this.mGestureDetector.setLongpressEnabled(this.isLongPressEnabled());
        }
    }

    @Override
    @CallSuper
    protected void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        DefaultGestureListener onGestureListener = new DefaultGestureListener(recyclerView);
        this.mGestureDetector = new EnchancedGestureDetector(recyclerView.getContext(), onGestureListener);
        this.mGestureDetector.setLongpressEnabled(this.isLongPressEnabled());
        recyclerView.addOnItemTouchListener(this.mOnItemTouchListener);
    }

    @Override
    @CallSuper
    protected void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        recyclerView.removeOnItemTouchListener(this.mOnItemTouchListener);
        this.mGestureDetector = null;
    }

    protected boolean performClick(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
        int position = viewHolder.getAdapterPosition();
        E item = this.mCallback.get(position);
        return this.mOnItemClickListener != null && this.mOnItemClickListener.onItemClick(view, item, position);
    }

    protected boolean performLongPress(@NonNull RecyclerView.ViewHolder viewHolder, @NonNull View view) {
        int position = viewHolder.getAdapterPosition();
        E item = this.mCallback.get(position);
        return this.mOnItemLongClickListener != null && this.mOnItemLongClickListener.onItemLongClick(view, item, position);
    }

    public static interface Callback<E> {
        @NonNull
        public E get(@IntRange(from=0L) int var1);

        @NonNull
        public ClickableViews getClickableViews(@IntRange(from=0L) int var1, int var2);
    }

    private class DefaultGestureListener
    extends EnchancedGestureDetector.SimpleOnGestureListener {
        @NonNull
        private final ClickableViewFinder mViewFinder;
        @Nullable
        private ClickableViewFinder.Target mTarget;

        DefaultGestureListener(RecyclerView recyclerView) {
            this.mViewFinder = new ClickableViewFinder(recyclerView, ItemClickHelper.this.mCallback);
        }

        @Override
        public boolean onDown(@NonNull MotionEvent event) {
            this.mTarget = this.mViewFinder.findTarget(event.getX(), event.getY());
            return this.mTarget != null;
        }

        @Override
        public void onShowPress(@NonNull MotionEvent event) {
            if (this.mTarget != null) {
                this.mTarget.setPressed(true, event.getX(), event.getY());
            }
        }

        @Override
        public boolean onSingleTapUp(@NonNull MotionEvent event) {
            if (this.mTarget != null) {
                boolean handled = ItemClickHelper.this.performClick(this.mTarget.getViewHolder(), this.mTarget.getView());
                this.mTarget.setPressed(false);
                this.mTarget = null;
                return handled;
            }
            return false;
        }

        @Override
        public void onHidePress() {
            if (this.mTarget != null) {
                this.mTarget.setPressed(false);
                this.mTarget = null;
            }
        }

        @Override
        public void onLongPress(@NonNull MotionEvent e) {
            if (this.mTarget != null) {
                ItemClickHelper.this.performLongPress(this.mTarget.getViewHolder(), this.mTarget.getView());
            }
        }
    }

    private class OnItemTouchListener
    extends RecyclerView.SimpleOnItemTouchListener {
        private OnItemTouchListener() {
        }

        public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
            return ItemClickHelper.this.mGestureDetector != null && ItemClickHelper.this.mGestureDetector.onTouchEvent(e);
        }

        public void onTouchEvent(RecyclerView rv, MotionEvent e) {
            if (ItemClickHelper.this.mGestureDetector != null) {
                ItemClickHelper.this.mGestureDetector.onTouchEvent(e);
            }
        }
    }
}

