/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.globusltd.recyclerview.view.SimpleEnableBehavior;

public class RecursiveEnableBehavior
extends SimpleEnableBehavior {
    public RecursiveEnableBehavior(@NonNull SimpleEnableBehavior.Callback callback) {
        super(callback);
    }

    @Override
    protected void onEnabledChanged(@NonNull RecyclerView.ViewHolder viewHolder, boolean enabled) {
        this.setEnabledRecursively(viewHolder.itemView, enabled);
    }

    private void setEnabledRecursively(@NonNull View view, boolean enabled) {
        view.setEnabled(enabled);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int index = 0; index < childCount; ++index) {
                View child = viewGroup.getChildAt(index);
                this.setEnabledRecursively(child, enabled);
            }
        }
    }
}

