/*
 * Decompiled with CFR 0.152.
 */
package com.globusltd.recyclerview.view;

import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import com.globusltd.recyclerview.ViewHolderObserver;

@MainThread
public class SimpleEnableBehavior
implements ViewHolderObserver {
    @NonNull
    private final Callback mCallback;

    public SimpleEnableBehavior(@NonNull Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void onAttached(@NonNull RecyclerView.ViewHolder viewHolder) {
        this.updateItemViewEnabled(viewHolder);
    }

    @Override
    public void onPositionChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
        this.updateItemViewEnabled(viewHolder);
    }

    @Override
    public void onChanged(@NonNull RecyclerView.ViewHolder viewHolder) {
        this.updateItemViewEnabled(viewHolder);
    }

    private void updateItemViewEnabled(@NonNull RecyclerView.ViewHolder viewHolder) {
        int position = viewHolder.getAdapterPosition();
        if (position > -1) {
            boolean isEnabled = this.mCallback.isEnabled(position);
            this.onEnabledChanged(viewHolder, isEnabled);
        } else {
            this.onEnabledChanged(viewHolder, false);
        }
    }

    protected void onEnabledChanged(@NonNull RecyclerView.ViewHolder viewHolder, boolean enabled) {
        viewHolder.itemView.setEnabled(enabled);
    }

    @Override
    public void onDetached(@NonNull RecyclerView.ViewHolder viewHolder) {
        this.onEnabledChanged(viewHolder, false);
    }

    public static interface Callback {
        public boolean isEnabled(@IntRange(from=0L) int var1);
    }
}

