/*
 * Decompiled with CFR 0.152.
 */
package com.glovoapp.versioning.tasks;

import com.glovoapp.versioning.PersistedVersion;
import com.glovoapp.versioning.SemanticVersion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u000bH\u0007J\u0016\u0010\t\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u001cH\u0007J\b\u0010 \u001a\u00020\u001cH\u0007J\b\u0010!\u001a\u00020\u001cH\u0007J\u0016\u0010\u0011\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0007J\b\u0010\"\u001a\u00020\u001cH\u0007J\b\u0010#\u001a\u00020\u001cH\u0007J\b\u0010$\u001a\u00020\u001cH\u0007R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000f0\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR$\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR$\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\"\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\b\u00a8\u0006%"}, d2={"Lcom/glovoapp/versioning/tasks/IncrementSemanticVersionTask;", "Lorg/gradle/api/DefaultTask;", "()V", "amount", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getAmount", "()Lorg/gradle/api/provider/Property;", "buildLabels", "Lorg/gradle/api/provider/ListProperty;", "", "getBuildLabels", "()Lorg/gradle/api/provider/ListProperty;", "increment", "Lcom/glovoapp/versioning/SemanticVersion$Increment;", "getIncrement", "preReleaseLabels", "getPreReleaseLabels", "preserveBuild", "", "getPreserveBuild", "preservePreRelease", "getPreservePreRelease", "version", "Lcom/glovoapp/versioning/PersistedVersion;", "Lcom/glovoapp/versioning/SemanticVersion;", "getVersion", "", "labels", "", "major", "minor", "patch", "preserve", "release", "run", "gradle-versioning-plugin"})
public class IncrementSemanticVersionTask
extends DefaultTask {
    @Internal
    @NotNull
    private final Property<PersistedVersion<SemanticVersion>> version;
    @Input
    @Option(option="increment", description="The increment type")
    @NotNull
    private final Property<SemanticVersion.Increment> increment;
    @Input
    @NotNull
    private final Property<Integer> amount;
    @Input
    @Option(option="preserve-pre-release", description="Add or replace current pre-release labels")
    @NotNull
    private final Property<Boolean> preservePreRelease;
    @Input
    @Option(option="preserve-build", description="Add or replace current build labels")
    @NotNull
    private final Property<Boolean> preserveBuild;
    @Input
    @NotNull
    private final ListProperty<String> preReleaseLabels;
    @Input
    @NotNull
    private final ListProperty<String> buildLabels;

    @NotNull
    public final Property<PersistedVersion<SemanticVersion>> getVersion() {
        return this.version;
    }

    @NotNull
    public final Property<SemanticVersion.Increment> getIncrement() {
        return this.increment;
    }

    @NotNull
    public final Property<Integer> getAmount() {
        return this.amount;
    }

    @NotNull
    public final Property<Boolean> getPreservePreRelease() {
        return this.preservePreRelease;
    }

    @NotNull
    public final Property<Boolean> getPreserveBuild() {
        return this.preserveBuild;
    }

    @NotNull
    public final ListProperty<String> getPreReleaseLabels() {
        return this.preReleaseLabels;
    }

    @NotNull
    public final ListProperty<String> getBuildLabels() {
        return this.buildLabels;
    }

    @Option(option="major", description="Increments major version")
    public final void major() {
        this.increment.set((Object)SemanticVersion.Increment.MAJOR);
    }

    @Option(option="minor", description="Increments minor version")
    public final void minor() {
        this.increment.set((Object)SemanticVersion.Increment.MINOR);
    }

    @Option(option="patch", description="Increments patch version")
    public final void patch() {
        this.increment.set((Object)SemanticVersion.Increment.PATCH);
    }

    /*
     * WARNING - void declaration
     */
    @Option(option="amount", description="The increment amount")
    public final void amount(@NotNull String amount) {
        Integer n;
        Property<Integer> property;
        boolean bl;
        boolean bl2;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Property<Integer> property2 = this.amount;
        Integer n3 = StringsKt.toIntOrNull((String)amount);
        if (n3 != null) {
            void it;
            n2 = n3;
            bl2 = false;
            bl = false;
            int n4 = ((Number)n2).intValue();
            property = property2;
            boolean bl3 = false;
            boolean bl4 = it >= 0;
            property2 = property;
            n = bl4 ? n2 : null;
        } else {
            n = null;
        }
        n2 = n;
        bl2 = false;
        bl = false;
        if (n2 == null) {
            property = property2;
            boolean bl5 = false;
            String string = "amount `" + amount + "` must be >= 0";
            Property<Integer> property3 = property;
            String string2 = string;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        property2.set((Object)n2);
    }

    @Option(option="preserve", description="Add or replace current pre-release and build labels")
    public final void preserve() {
        this.preservePreRelease.set((Object)true);
        this.preserveBuild.set((Object)true);
    }

    @Option(option="pre-release", description="Adds pre-release labels to the version")
    public final void preReleaseLabels(@NotNull List<String> labels) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        this.preReleaseLabels.set((Iterable)labels);
    }

    @Option(option="release", description="Converts the current version into a release, by removing all `pre-release` tags")
    public final void release() {
        this.preReleaseLabels.set((Iterable)CollectionsKt.emptyList());
        this.preservePreRelease.set((Object)false);
    }

    @Option(option="build", description="Adds build labels to the version")
    public final void buildLabels(@NotNull List<String> labels) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        this.buildLabels.set((Iterable)labels);
    }

    @TaskAction
    public final void run() {
        Object object = this.version.get();
        boolean bl = false;
        boolean bl2 = false;
        PersistedVersion $this$with = (PersistedVersion)object;
        boolean bl3 = false;
        Function1<List<? extends String>, List<? extends String>> $fun$ifPreserved$1 = new Function1<List<? extends String>, List<? extends String>>(this){
            final /* synthetic */ IncrementSemanticVersionTask this$0;
            {
                this.this$0 = incrementSemanticVersionTask;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull List<String> $this$ifPreserved) {
                Intrinsics.checkNotNullParameter($this$ifPreserved, (String)"$this$ifPreserved");
                Object object = this.this$0.getPreservePreRelease().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"preservePreRelease.get()");
                return (Boolean)object != false ? $this$ifPreserved : CollectionsKt.emptyList();
            }
        };
        Collection collection = $fun$ifPreserved$1.invoke((List<String>)((SemanticVersion)$this$with.getValue()).getPreReleaseIdentifiers());
        Object object2 = this.preReleaseLabels.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"preReleaseLabels.get()");
        List prLabels = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object2));
        Collection collection2 = $fun$ifPreserved$1.invoke((List<String>)((SemanticVersion)$this$with.getValue()).getBuildIdentifiers());
        Object object3 = this.buildLabels.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"buildLabels.get()");
        List bLabels = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)object3));
        SemanticVersion semanticVersion = (SemanticVersion)$this$with.getValue();
        SemanticVersion.Increment increment = (SemanticVersion.Increment)this.increment.get();
        Object object4 = this.amount.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"amount.get()");
        $this$with.setValue((Object)SemanticVersion.copy$default((SemanticVersion)semanticVersion.plus(increment.times(((Number)object4).intValue())), (int)0, null, null, (String)CollectionsKt.joinToString$default((Iterable)prLabels, (CharSequence)".", null, null, (int)0, null, null, (int)62, null), (String)CollectionsKt.joinToString$default((Iterable)bLabels, (CharSequence)".", null, null, (int)0, null, null, (int)62, null), (int)7, null));
    }

    public IncrementSemanticVersionTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(PersistedVersion.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.version = property;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ObjectFactory objectFactory2 = project2.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory2, (String)"project.objects");
        $this$property$iv = objectFactory2;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(SemanticVersion.Increment.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Property property3 = property2.convention((Object)SemanticVersion.Increment.PATCH);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property\u2026cVersion.Increment.PATCH)");
        this.increment = property3;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ObjectFactory objectFactory3 = project3.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory3, (String)"project.objects");
        $this$property$iv = objectFactory3;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        Property property5 = property4.convention((Object)1);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects.property<Int>().convention(1)");
        this.amount = property5;
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        ObjectFactory objectFactory4 = project4.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory4, (String)"project.objects");
        $this$property$iv = objectFactory4;
        $i$f$property = false;
        Property property6 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(T::class.java)");
        Property property7 = property6.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"project.objects.property\u2026lean>().convention(false)");
        this.preservePreRelease = property7;
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        ObjectFactory objectFactory5 = project5.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory5, (String)"project.objects");
        $this$property$iv = objectFactory5;
        $i$f$property = false;
        Property property8 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property8, (String)"property(T::class.java)");
        Property property9 = property8.convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property9, (String)"project.objects.property\u2026lean>().convention(false)");
        this.preserveBuild = property9;
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        ObjectFactory objectFactory6 = project6.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory6, (String)"project.objects");
        ObjectFactory $this$listProperty$iv = objectFactory6;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.preReleaseLabels = listProperty;
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
        ObjectFactory objectFactory7 = project7.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory7, (String)"project.objects");
        $this$listProperty$iv = objectFactory7;
        $i$f$listProperty = false;
        ListProperty listProperty2 = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"listProperty(T::class.java)");
        this.buildLabels = listProperty2;
    }
}

