/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.position;

public class Parameters {
    private final Accuracy accuracy;
    private final long timeInterval;
    private final float distanceFilter;
    private final boolean backgroundModeEnabled;

    public Parameters(Accuracy accuracy, boolean backgroundModeEnabled) {
        this(accuracy, accuracy.getTimeInterval(), accuracy.getDistanceFilter(), backgroundModeEnabled);
    }

    public Parameters(Accuracy accuracy, long timeInterval, float distanceFilter, boolean backgroundModeEnabled) {
        this.accuracy = accuracy;
        this.timeInterval = timeInterval;
        this.distanceFilter = distanceFilter;
        this.backgroundModeEnabled = backgroundModeEnabled;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public float getDistanceFilter() {
        return this.distanceFilter;
    }

    public boolean isBackgroundModeEnabled() {
        return this.backgroundModeEnabled;
    }

    public String toString() {
        return "Parameters{accuracy=" + this.accuracy + ", timeInterval=" + this.timeInterval + ", distanceFilter=" + this.distanceFilter + ", backgroundModeEnabled=" + this.backgroundModeEnabled + "}";
    }

    public static enum Accuracy {
        LOWEST(90000L, 1000.0f),
        LOW(30000L, 100.0f),
        MEDIUM(5000L, 15.0f),
        HIGH(1000L, 1.0f),
        HIGHEST(100L, 0.0f);

        final long timeInterval;
        final float distanceFilter;

        private Accuracy(long timeInterval, float distanceFilter) {
            this.timeInterval = timeInterval;
            this.distanceFilter = distanceFilter;
        }

        public long getTimeInterval() {
            return this.timeInterval;
        }

        public float getDistanceFilter() {
            return this.distanceFilter;
        }
    }
}

