/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.position.impl.geotools;

import java.io.Serializable;

public abstract class AbstractMathTransform {
    protected AbstractMathTransform() {
    }

    public abstract int getSourceDimensions();

    public abstract int getTargetDimensions();

    public boolean isIdentity() {
        return false;
    }

    private static String constructMessage(String argument, int dimension, int expected) {
        StringBuilder sb = new StringBuilder();
        sb.append(argument);
        sb.append(",");
        sb.append(dimension);
        sb.append(",");
        sb.append(expected);
        return sb.toString();
    }

    public int hashCode() {
        return this.getSourceDimensions() + 37 * this.getTargetDimensions();
    }

    protected static boolean needCopy(int srcOff, int dimSource, int dstOff, int dimTarget, int numPts) {
        if (numPts <= 1 || srcOff >= dstOff && dimSource >= dimTarget) {
            return false;
        }
        return srcOff < dstOff + numPts * dimTarget && dstOff < srcOff + numPts * dimSource;
    }

    protected static double rollLongitude(double x) {
        return x - Math.PI * 2 * Math.floor(x / (Math.PI * 2) + 0.5);
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        public int hashCode() {
            return ~AbstractMathTransform.this.hashCode();
        }
    }
}

