/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.video.impl;

import com.gluonhq.attach.storage.StorageService;
import com.gluonhq.attach.util.Services;
import com.gluonhq.attach.util.Util;
import com.gluonhq.attach.video.VideoService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class DefaultVideoService
implements VideoService {
    private static final Logger LOG = Logger.getLogger(DefaultVideoService.class.getName());
    protected final boolean debug = Util.DEBUG;
    private final ExecutorService exec = Executors.newFixedThreadPool(3);
    protected final ObservableList<String> playlist = FXCollections.observableArrayList();
    protected final Map<String, Boolean> playlistMap = new HashMap<String, Boolean>();
    private final File assetsFolder = new File((File)Services.get(StorageService.class).flatMap(service -> service.getPrivateStorage()).orElseThrow(() -> new RuntimeException("Error accessing Private Storage folder")), "assets");

    public DefaultVideoService() {
        if (!this.assetsFolder.exists()) {
            this.assetsFolder.mkdir();
        }
        this.playlist.addListener(c -> {
            while (c.next()) {
                if (this.debug) {
                    LOG.log(Level.INFO, String.format("Playlist changed: %s", c.toString()));
                }
                if (c.wasAdded()) {
                    for (final String s : c.getAddedSubList()) {
                        if (s == null || s.isEmpty()) continue;
                        if (!this.getFileFromAssets(s).exists()) {
                            FutureTask<Boolean> futureTask = new FutureTask<Boolean>((Callable)new CopyFile(s)){

                                @Override
                                protected void done() {
                                    try {
                                        DefaultVideoService.this.playlistMap.put(s, (Boolean)this.get());
                                        if (DefaultVideoService.this.debug) {
                                            LOG.log(Level.INFO, String.format("Copying video file %s finished with result: %s", s, DefaultVideoService.this.playlistMap.get(s) != false ? "ok" : "failed"));
                                        }
                                    }
                                    catch (InterruptedException | ExecutionException ex) {
                                        LOG.log(Level.SEVERE, "Error future task", ex);
                                    }
                                }
                            };
                            Future<?> submit = this.exec.submit(futureTask);
                            if (!s.equals(this.playlist.get(this.currentIndexProperty().get()))) continue;
                            try {
                                submit.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                LOG.log(Level.WARNING, "Error while waiting for thread completion", e);
                            }
                            continue;
                        }
                        if (this.debug) {
                            LOG.log(Level.INFO, String.format("file: %s already exists", s));
                        }
                        this.playlistMap.put(s, true);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                for (final String s : c.getRemoved()) {
                    this.playlistMap.remove(s);
                }
            }
        });
    }

    @Override
    public ObservableList<String> getPlaylist() {
        return this.playlist;
    }

    protected boolean checkFileInResources(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return false;
        }
        Object pathIni = filePath;
        if (!filePath.startsWith("/")) {
            pathIni = "/" + (String)pathIni;
        }
        return DefaultVideoService.class.getResource((String)pathIni) != null;
    }

    protected File getFileFromAssets(String filePath) {
        return new File(this.assetsFolder, filePath.replaceAll("/", "_"));
    }

    private class CopyFile
    implements Callable<Boolean> {
        private final String filePath;

        public CopyFile(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.filePath == null || this.filePath.isEmpty()) {
                return Boolean.FALSE;
            }
            File videoFile = DefaultVideoService.this.getFileFromAssets(this.filePath);
            if (!videoFile.exists()) {
                if (DefaultVideoService.this.debug) {
                    LOG.log(Level.INFO, String.format("Copying video file: %s, from resources to %s", this.filePath, videoFile.getAbsolutePath()));
                }
                Object pathIni = this.filePath;
                if (!this.filePath.startsWith("/")) {
                    pathIni = "/" + (String)pathIni;
                }
                if (!this.copyFile((String)pathIni, videoFile.getAbsolutePath())) {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private boolean copyFile(String pathIni, String pathEnd) {
            block18: {
                try (InputStream myInput = DefaultVideoService.class.getResourceAsStream(pathIni);){
                    boolean bl;
                    if (myInput == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    FileOutputStream myOutput = new FileOutputStream(pathEnd);
                    try {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = myInput.read(buffer)) > 0) {
                            ((OutputStream)myOutput).write(buffer, 0, length);
                        }
                        myOutput.flush();
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((OutputStream)myOutput).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            LOG.log(Level.WARNING, "Error copying file", ex);
                            break block18;
                        }
                    }
                    ((OutputStream)myOutput).close();
                    return bl;
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Error copying file", ex);
                }
            }
            return false;
        }
    }
}

