/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.CognitoCredentialsProvider;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.util.VersionInfoUtils;
import com.gluonhq.charm.down.Services;
import com.gluonhq.charm.down.plugins.SettingsService;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CognitoCachingCredentialsProvider
extends CognitoCredentialsProvider {
    private static final Logger LOG = Logger.getLogger(CognitoCachingCredentialsProvider.class.getName());
    private static final String USER_AGENT = CognitoCachingCredentialsProvider.class.getName() + "/" + VersionInfoUtils.getVersion();
    private final SettingsService prefs;
    private String identityId;
    private static final String ID_KEY = "identityId";
    private static final String AK_KEY = "accessKey";
    private static final String SK_KEY = "secretKey";
    private static final String ST_KEY = "sessionToken";
    private static final String EXP_KEY = "expirationDate";
    volatile boolean needIdentityRefresh = false;
    private final IdentityChangedListener listener = new IdentityChangedListener(){

        @Override
        public void identityChanged(String oldIdentityId, String newIdentityId) {
            LOG.log(Level.FINE, "Identity id is changed");
            CognitoCachingCredentialsProvider.this.saveIdentityId(newIdentityId);
            CognitoCachingCredentialsProvider.this.clearCredentials();
        }
    };

    public CognitoCachingCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) throws Throwable {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) throws Throwable {
        super(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, clientConfiguration);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(String identityPoolId, Regions region) throws Throwable {
        super(identityPoolId, region);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(AWSConfiguration awsConfiguration) throws Throwable {
        super(awsConfiguration);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(String identityPoolId, Regions region, ClientConfiguration clientConfiguration) throws Throwable {
        super(identityPoolId, region, clientConfiguration);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(String accountId, String identityPoolId, String unauthArn, String authArn, AmazonCognitoIdentityClient cibClient, AWSSecurityTokenService stsClient) throws Throwable {
        super(accountId, identityPoolId, unauthArn, authArn, cibClient, stsClient);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn) throws Throwable {
        super(provider, unauthArn, authArn);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn, AWSSecurityTokenService stsClient) throws Throwable {
        super(provider, unauthArn, authArn, stsClient);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(AWSCognitoIdentityProvider provider, Regions region) throws Throwable {
        super(provider, region);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    public CognitoCachingCredentialsProvider(AWSCognitoIdentityProvider provider, Regions region, ClientConfiguration clientConfiguration) throws Throwable {
        super(provider, region, clientConfiguration);
        this.prefs = (SettingsService)Services.get(SettingsService.class).orElseThrow(new Supplier(){

            public Object get() {
                throw new RuntimeException("Error accessing Settings Service");
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.checkUpgrade();
        this.identityId = this.getCachedIdentityId();
        this.loadCachedCredentials();
        this.registerIdentityChangedListener(this.listener);
    }

    @Override
    public String getIdentityId() {
        if (this.needIdentityRefresh) {
            this.needIdentityRefresh = false;
            this.refresh();
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        this.identityId = this.getCachedIdentityId();
        if (this.identityId == null) {
            this.identityId = super.getIdentityId();
            this.saveIdentityId(this.identityId);
        }
        return this.identityId;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            if (this.sessionCredentials == null) {
                this.loadCachedCredentials();
            }
            if (this.sessionCredentialsExpiration != null && !this.needsNewSession()) {
                AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
                return aWSSessionCredentials;
            }
            super.getCredentials();
            if (this.sessionCredentialsExpiration != null) {
                this.saveCredentials(this.sessionCredentials, this.sessionCredentialsExpiration.getTime());
            }
            AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
            return aWSSessionCredentials;
        }
        catch (NotAuthorizedException e) {
            LOG.log(Level.WARNING, "Failure to get credentials", e);
            if (this.getLogins() != null) {
                super.setIdentityId(null);
                super.getCredentials();
                AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
                return aWSSessionCredentials;
            }
            throw e;
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void refresh() {
        this.credentialsLock.writeLock().lock();
        try {
            super.refresh();
            if (this.sessionCredentialsExpiration != null) {
                this.saveCredentials(this.sessionCredentials, this.sessionCredentialsExpiration.getTime());
            }
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLogins(Map<String, String> logins) {
        this.credentialsLock.writeLock().lock();
        try {
            super.setLogins(logins);
            this.needIdentityRefresh = true;
            this.clearCredentials();
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.clearPrefs();
    }

    @Override
    public void clearCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            super.clearCredentials();
            LOG.log(Level.FINE, "Clearing credentials from SharedPreferences");
            this.prefs.remove(this.namespace(AK_KEY));
            this.prefs.remove(this.namespace(SK_KEY));
            this.prefs.remove(this.namespace(ST_KEY));
            this.prefs.remove(this.namespace(EXP_KEY));
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public String getCachedIdentityId() {
        String cachedIdentityId = this.prefs.retrieve(this.namespace(ID_KEY));
        if (cachedIdentityId != null && this.identityId == null) {
            super.setIdentityId(cachedIdentityId);
        }
        return cachedIdentityId;
    }

    void loadCachedCredentials() {
        boolean hasST;
        LOG.log(Level.FINE, "Loading credentials from SharedPreferences");
        String value = this.prefs.retrieve(this.namespace(EXP_KEY));
        this.sessionCredentialsExpiration = value != null && !value.isEmpty() ? new Date(Long.valueOf(value)) : null;
        boolean hasAK = this.prefs.retrieve(this.namespace(AK_KEY)) != null;
        boolean hasSK = this.prefs.retrieve(this.namespace(SK_KEY)) != null;
        boolean bl = hasST = this.prefs.retrieve(this.namespace(ST_KEY)) != null;
        if (!(hasAK && hasSK && hasST)) {
            LOG.log(Level.FINE, "No valid credentials found in SharedPreferences");
            this.sessionCredentialsExpiration = null;
            return;
        }
        String AK = this.prefs.retrieve(this.namespace(AK_KEY));
        String SK = this.prefs.retrieve(this.namespace(SK_KEY));
        String ST = this.prefs.retrieve(this.namespace(ST_KEY));
        this.sessionCredentials = new BasicSessionCredentials(AK, SK, ST);
    }

    private void saveCredentials(AWSSessionCredentials sessionCredentials, long time) {
        LOG.log(Level.FINE, "Saving credentials to SharedPreferences");
        if (sessionCredentials != null) {
            this.prefs.store(this.namespace(AK_KEY), sessionCredentials.getAWSAccessKeyId());
            this.prefs.store(this.namespace(SK_KEY), sessionCredentials.getAWSSecretKey());
            this.prefs.store(this.namespace(ST_KEY), sessionCredentials.getSessionToken());
            this.prefs.store(this.namespace(EXP_KEY), Long.toString(time));
        }
    }

    private void saveIdentityId(String identityId) {
        LOG.log(Level.FINE, "Saving identity id to SharedPreferences");
        this.identityId = identityId;
        this.prefs.store(this.namespace(ID_KEY), identityId);
    }

    @Override
    protected String getUserAgent() {
        return USER_AGENT;
    }

    private void checkUpgrade() {
        if (this.prefs.retrieve(ID_KEY) != null) {
            LOG.log(Level.INFO, "Identity id without namespace is detected. It will be saved under new namespace.");
            String identityId = this.prefs.retrieve(ID_KEY);
            this.clearPrefs();
            this.prefs.store(this.namespace(ID_KEY), identityId);
        }
    }

    private String namespace(String key) {
        return this.getIdentityPoolId() + "." + key;
    }

    private void clearPrefs() {
        this.prefs.remove(this.namespace(ID_KEY));
        this.prefs.remove(this.namespace(AK_KEY));
        this.prefs.remove(this.namespace(SK_KEY));
        this.prefs.remove(this.namespace(ST_KEY));
        this.prefs.remove(this.namespace(EXP_KEY));
    }
}

