/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.config;

import java.io.InputStream;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;

public class AWSConfiguration {
    private static final String DEFAULT = "Default";
    private static final String DEFAULT_IDENTIFIER = "awsconfiguration.json";
    private JSONObject mJSONObject;
    private String configName;

    public AWSConfiguration() {
        this(AWSConfiguration.getConfigResource());
    }

    private static String getConfigResource() {
        try {
            AWSConfiguration.class.getResource("/awsconfiguration.json").toExternalForm();
            return DEFAULT_IDENTIFIER;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read awsconfiguration.json please check that it is correctly formed.", e);
        }
    }

    public AWSConfiguration(String configResource) {
        this(configResource, DEFAULT);
    }

    public AWSConfiguration(String configResource, String configName) {
        this.configName = configName;
        this.readInputJson(configResource);
    }

    private void readInputJson(String resource) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + resource);
            Scanner in = new Scanner(inputStream);
            StringBuilder sb = new StringBuilder();
            while (in.hasNextLine()) {
                sb.append(in.nextLine());
            }
            in.close();
            this.mJSONObject = new JSONObject(sb.toString());
        }
        catch (Exception je) {
            throw new RuntimeException("Failed to read awsconfiguration.json please check that it is correctly formed.", je);
        }
    }

    public JSONObject optJsonObject(String key) {
        try {
            JSONObject value = this.mJSONObject.getJSONObject(key);
            if (value.has(this.configName)) {
                value = value.getJSONObject(this.configName);
            }
            return new JSONObject(value.toString());
        }
        catch (JSONException je) {
            return null;
        }
    }

    public String getUserAgent() {
        try {
            return this.mJSONObject.getString("UserAgent");
        }
        catch (JSONException je) {
            return "";
        }
    }

    public void setConfiguration(String configurationName) {
        this.configName = configurationName;
    }

    public String getConfiguration() {
        return this.configName;
    }

    public String toString() {
        return this.mJSONObject.toString();
    }
}

