/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DownloadTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(DownloadTask.class);
    private static final int SIXTEEN_KB = 16384;
    private final AmazonS3 s3;
    private final TransferRecord download;
    private final TransferStatusUpdater updater;
    private final TransferService.NetworkInfoReceiver networkInfo;

    public DownloadTask(TransferRecord download, AmazonS3 s3, TransferStatusUpdater updater, TransferService.NetworkInfoReceiver networkInfo) {
        this.download = download;
        this.s3 = s3;
        this.updater = updater;
        this.networkInfo = networkInfo;
    }

    @Override
    public Boolean call() throws Exception {
        if (!this.networkInfo.isNetworkConnected()) {
            this.updater.updateState(this.download.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
            return false;
        }
        this.updater.updateState(this.download.getRecord().getId(), TransferState.IN_PROGRESS);
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.download.getRecord().getBucketName(), this.download.getRecord().getKey());
        TransferUtility.appendTransferServiceUserAgentString(getObjectRequest);
        File file = new File(this.download.getRecord().getFile());
        long bytesCurrent = file.length();
        if (bytesCurrent > 0L) {
            LOGGER.debug((Object)String.format("Resume transfer %d from %d bytes", this.download.getRecord().getId(), bytesCurrent));
            getObjectRequest.setRange(bytesCurrent, -1L);
        }
        getObjectRequest.setGeneralProgressListener(this.updater.newProgressListener(this.download.getRecord().getId()));
        try {
            S3Object object = this.s3.getObject(getObjectRequest);
            if (object == null) {
                this.updater.throwError(this.download.getRecord().getId(), new IllegalStateException("AmazonS3.getObject returns null"));
                this.updater.updateState(this.download.getRecord().getId(), TransferState.FAILED);
                return false;
            }
            long bytesTotal = object.getObjectMetadata().getInstanceLength();
            this.updater.updateProgress(this.download.getRecord().getId(), bytesCurrent, bytesTotal);
            this.saveToFile((InputStream)((Object)object.getObjectContent()), file);
            this.updater.updateProgress(this.download.getRecord().getId(), bytesTotal, bytesTotal);
            this.updater.updateState(this.download.getRecord().getId(), TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.debug((Object)("Transfer " + this.download.getRecord().getId() + " is interrupted by user"));
            } else if (e.getCause() != null && (e.getCause() instanceof IOException || e.getCause() instanceof AmazonClientException) && !this.networkInfo.isNetworkConnected()) {
                LOGGER.debug((Object)("Transfer " + this.download.getRecord().getId() + " waits for network"));
                this.updater.updateState(this.download.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
            } else {
                LOGGER.debug((Object)("Failed to download: " + this.download.getRecord().getId() + " due to " + e.getMessage()));
                this.updater.throwError(this.download.getRecord().getId(), e);
                this.updater.updateState(this.download.getRecord().getId(), TransferState.FAILED);
            }
            return false;
        }
    }

    private void saveToFile(InputStream is, File file) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        boolean append = file.length() > 0L;
        OutputStream os = null;
        try {
            int bytesRead;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] buffer = new byte[16384];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            String errorString = "SocketTimeoutException: Unable to retrieve contents over network: " + socketTimeoutException.getMessage();
            LOGGER.error((Object)errorString);
            throw new AmazonClientException(errorString, (Throwable)socketTimeoutException);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"got exception", (Throwable)ioe);
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"got exception", (Throwable)ioe);
            }
        }
    }
}

