/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.mobileconnectors.s3.transferutility.Record;
import com.gluonhq.cloudlink.client.data.DataClient;
import com.gluonhq.cloudlink.client.data.DataClientBuilder;
import com.gluonhq.cloudlink.client.data.OperationMode;
import com.gluonhq.cloudlink.client.data.SyncFlag;
import com.gluonhq.connect.ConnectState;
import com.gluonhq.connect.GluonObservableList;
import com.gluonhq.connect.provider.DataProvider;
import com.gluonhq.connect.provider.ListDataReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class Service {
    private static final Logger LOG = Logger.getLogger(Service.class.getName());
    private static final String DATABASE_NAME = "AWS_LOCAL_DATABASE";
    private final DataClient dataClient = DataClientBuilder.create().operationMode(OperationMode.LOCAL_ONLY).build();
    private GluonObservableList<Record> records;
    private static Service instance;

    public static Service getInstance() {
        if (instance == null) {
            instance = new Service();
        }
        return instance;
    }

    private Service() {
        this.retrieveRecords(DATABASE_NAME);
    }

    private void retrieveRecords(String databaseName) {
        this.records = DataProvider.retrieveList((ListDataReader)this.dataClient.createListDataReader(databaseName, Record.class, new SyncFlag[]{SyncFlag.LIST_WRITE_THROUGH, SyncFlag.OBJECT_WRITE_THROUGH}));
        this.records.exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> observable, Throwable oldValue, Throwable newValue) {
                LOG.log(Level.WARNING, "Exception dataClient", newValue);
            }
        });
        this.records.stateProperty().addListener((ChangeListener)new ChangeListener<ConnectState>(){

            public void changed(ObservableValue<? extends ConnectState> observable, ConnectState oldValue, ConnectState newValue) {
                LOG.log(Level.INFO, "State dataClient: " + newValue);
            }
        });
        LOG.log(Level.INFO, "Initial state dataClient: " + this.records.getState());
    }

    public ObservableList<Record> getRecords() {
        return this.records;
    }

    public Record getRecord(int id) {
        for (Record record : this.records) {
            if (record.getId() != id) continue;
            return record;
        }
        return new Record();
    }

    public void updateRecord(Record oldRecord, Record newRecord) {
        Record r = this.getRecord(oldRecord.getId());
        if (r.getId() == oldRecord.getId()) {
            this.removeRecord(oldRecord);
            this.addRecord(newRecord);
            this.dataClient.push(this.records);
        }
    }

    public void addRecord(Record record) {
        LOG.log(Level.INFO, "Adding record " + record);
        this.records.add((Object)record);
        LOG.log(Level.INFO, "Push records");
        this.dataClient.push(this.records);
    }

    public void removeRecord(Record record) {
        LOG.log(Level.INFO, "Removing record " + record);
        this.records.remove((Object)record);
        this.dataClient.push(this.records);
    }
}

