/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.mobileconnectors.s3.transferutility.Record;
import com.amazonaws.mobileconnectors.s3.transferutility.Service;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransferDBUtil {
    private static final Log LOGGER = LogFactory.getLog(TransferDBUtil.class);
    private static final String QUERY_PLACE_HOLDER_STRING = ",?";

    public int insertMultipartUploadRecord(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart) {
        Record record = this.generateRecordForMultiPartUpload(bucket, key, file, fileOffset, partNumber, uploadId, bytesTotal, isLastPart, new ObjectMetadata(), null);
        Service.getInstance().addRecord(record);
        return record.getId();
    }

    public int insertSingleTransferRecord(TransferType type, String bucket, String key, File file, ObjectMetadata metadata) {
        return this.insertSingleTransferRecord(type, bucket, key, file, metadata, null);
    }

    public int insertSingleTransferRecord(TransferType type, String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        Record record = this.generateRecordForSinglePartTransfer(type, bucket, key, file, metadata, cannedAcl);
        Service.getInstance().addRecord(record);
        return record.getId();
    }

    public int insertSingleTransferRecord(TransferType type, String bucket, String key, File file) {
        return this.insertSingleTransferRecord(type, bucket, key, file, new ObjectMetadata());
    }

    public int bulkInsertTransferRecords(Record[] recordsArray) {
        for (Record record : recordsArray) {
            Service.getInstance().addRecord(record);
        }
        return recordsArray.length;
    }

    public int updateTransferRecord(TransferRecord transfer) {
        Record record = Service.getInstance().getRecord(transfer.getRecord().getId());
        record.setId(transfer.getRecord().getId());
        record.setState(transfer.getRecord().getState());
        record.setBytesTotal(transfer.getRecord().getBytesTotal());
        record.setBytesCurrent(transfer.getRecord().getBytesCurrent());
        Service.getInstance().updateRecord(transfer.getRecord(), record);
        return record.getId();
    }

    public int updateBytesTransferred(int id, long bytes) {
        Record record = this.getRecord(id);
        record.setBytesCurrent(bytes);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public int updateBytesTotalForDownload(int id, long bytes) {
        Record record = this.getRecord(id);
        record.setBytesTotal(bytes);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public int updateState(int id, TransferState state) {
        Record record = this.getRecord(id);
        record.setState(state);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public int updateStateAndNotifyUpdate(int id, TransferState state) {
        Record record = this.getRecord(id);
        record.setState(state);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public int updateMultipartId(int id, String multipartId) {
        Record record = this.getRecord(id);
        record.setMultipartId(multipartId);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public int updateETag(int id, String etag) {
        Record record = this.getRecord(id);
        record.seteTag(etag);
        Service.getInstance().updateRecord(this.getRecord(id), record);
        return record.getId();
    }

    public void updateNetworkDisconnected() {
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getState().equals((Object)TransferState.IN_PROGRESS) && !record.getState().equals((Object)TransferState.RESUMED_WAITING) && !record.getState().equals((Object)TransferState.WAITING)) continue;
            Record newRecord = record;
            newRecord.setState(TransferState.PENDING_NETWORK_DISCONNECT);
            Service.getInstance().updateRecord(record, newRecord);
        }
    }

    public void updateNetworkConnected() {
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getState().equals((Object)TransferState.PENDING_NETWORK_DISCONNECT) && !record.getState().equals((Object)TransferState.WAITING_FOR_NETWORK)) continue;
            Record newRecord = record;
            newRecord.setState(TransferState.RESUMED_WAITING);
            Service.getInstance().updateRecord(record, newRecord);
        }
    }

    public void setAllRunningRecordsToPausedBeforeShutdownService() {
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getState().equals((Object)TransferState.IN_PROGRESS) && !record.getState().equals((Object)TransferState.PENDING_PAUSE) && !record.getState().equals((Object)TransferState.RESUMED_WAITING) && !record.getState().equals((Object)TransferState.WAITING)) continue;
            Record newRecord = record;
            newRecord.setState(TransferState.PAUSED);
            Service.getInstance().updateRecord(record, newRecord);
        }
    }

    public long queryBytesTransferredByMainUploadId(int mainUploadId) {
        long bytesTotal = 0L;
        for (Record record : this.getPartRecord(mainUploadId)) {
            TransferState state = record.getState();
            if (!TransferState.PART_COMPLETED.equals((Object)TransferState.getState(state.name()))) continue;
            bytesTotal += record.getBytesTotal();
        }
        return bytesTotal;
    }

    public int deleteTransferRecords(int id) {
        Service.getInstance().removeRecord(this.getRecord(id));
        return id;
    }

    public List<PartETag> queryPartETagsOfUpload(int mainUploadId) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        for (Record record : this.getPartRecord(mainUploadId)) {
            int partNum = record.getPartNumber();
            String eTag = record.geteTag();
            partETags.add(new PartETag(partNum, eTag));
        }
        return partETags;
    }

    public List<UploadPartRequest> getNonCompletedPartRequestsFromDB(int mainUploadId, String multipartId) {
        ArrayList<UploadPartRequest> list = new ArrayList<UploadPartRequest>();
        for (Record record : this.getPartRecord(mainUploadId)) {
            TransferState state = record.getState();
            if (TransferState.PART_COMPLETED.equals((Object)TransferState.getState(state.name()))) continue;
            UploadPartRequest putPartRequest = new UploadPartRequest().withId(record.getId()).withMainUploadId(record.getMainUploadId()).withBucketName(record.getBucketName()).withKey(record.getKey()).withUploadId(multipartId).withFile(new File(record.getFile())).withFileOffset(record.getFileOffset()).withPartNumber(record.getPartNumber()).withPartSize(record.getBytesTotal()).withLastPart(1 == record.getIsLastPart());
            list.add(putPartRequest);
        }
        return list;
    }

    public boolean checkWaitingForNetworkPartRequestsFromDB(int mainUploadId) {
        boolean isNetworkInterrupted = false;
        for (Record record : this.getPartRecord(mainUploadId)) {
            if (!record.getState().equals((Object)TransferState.WAITING_FOR_NETWORK)) continue;
            isNetworkInterrupted = true;
            break;
        }
        return isNetworkInterrupted;
    }

    private String createPlaceholders(int numPlaceHolders) {
        if (numPlaceHolders <= 0) {
            LOGGER.error((Object)"Cannot create a string of 0 or less placeholders.");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(numPlaceHolders * QUERY_PLACE_HOLDER_STRING.length() - 1);
        stringBuilder.append("?");
        for (int index = 1; index < numPlaceHolders; ++index) {
            stringBuilder.append(QUERY_PLACE_HOLDER_STRING);
        }
        return stringBuilder.toString();
    }

    public Record generateRecordForMultiPartUpload(String bucket, String key, File file, long fileOffset, int partNumber, String uploadId, long bytesTotal, int isLastPart, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        Record record = new Record();
        record.setType(TransferType.UPLOAD);
        record.setState(TransferState.WAITING);
        record.setBucketName(bucket);
        record.setKey(key);
        record.setFile(file.getAbsolutePath());
        record.setBytesCurrent(0L);
        record.setBytesTotal(bytesTotal);
        record.setIsMultipart(1);
        record.setPartNumber(partNumber);
        record.setFileOffset(fileOffset);
        record.setMultipartId(uploadId);
        record.setIsLastPart(isLastPart);
        record.setIsEncrypted(0);
        this.setRecordForObjectMetadata(record, metadata);
        if (cannedAcl != null) {
            record.setCannedAcl(cannedAcl.toString());
        }
        return record;
    }

    private void setRecordForObjectMetadata(Record values, ObjectMetadata metadata) {
        values.setUserMetadata(metadata.getUserMetadata());
        values.setHeaderContentType(metadata.getContentType());
        values.setHeaderContentEncoding(metadata.getContentEncoding());
        values.setHeaderCacheControl(metadata.getCacheControl());
        values.setMd5(metadata.getContentMD5());
        values.setHeaderContentDisposition(metadata.getContentDisposition());
        values.setSseAlgorithm(metadata.getSSEAlgorithm());
        values.setSseKMSKey(metadata.getSSEAwsKmsKeyId());
        values.setExpirationTimeRuleId(metadata.getExpirationTimeRuleId());
        if (metadata.getHttpExpiresDate() != null) {
            values.setHttpExpires(String.valueOf(metadata.getHttpExpiresDate().getTime()));
        }
    }

    private Record generateRecordForSinglePartTransfer(TransferType type, String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        Record record = new Record();
        record.setType(type);
        record.setState(TransferState.WAITING);
        record.setBucketName(bucket);
        record.setKey(key);
        record.setFile(file.getAbsolutePath());
        record.setBytesCurrent(0L);
        if (type.equals((Object)TransferType.UPLOAD)) {
            record.setBytesTotal(file == null ? 0L : file.length());
        }
        record.setIsMultipart(0);
        record.setPartNumber(0);
        record.setIsEncrypted(0);
        this.setRecordForObjectMetadata(record, metadata);
        if (cannedAcl != null) {
            record.setCannedAcl(cannedAcl.toString());
        }
        return record;
    }

    public Record getRecord(int id) {
        return Service.getInstance().getRecord(id);
    }

    public List<Record> getPartRecord(int mainUploadId) {
        ArrayList<Record> records = new ArrayList<Record>();
        for (Record r : Service.getInstance().getRecords()) {
            if (!r.getMultipartId().equals(mainUploadId)) continue;
            records.add(r);
        }
        return records;
    }

    TransferRecord getTransferById(int id) {
        TransferRecord transfer = new TransferRecord();
        transfer.updateFromDB(this.getRecord(id));
        return transfer;
    }
}

