/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transferutility.DownloadTask;
import com.amazonaws.mobileconnectors.s3.transferutility.Record;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadTask;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransferRecord {
    private static final Log LOGGER = LogFactory.getLog(TransferRecord.class);
    private Record record;
    private Future<?> submittedTask;

    public void updateFromDB(Record record) {
        this.record = record;
    }

    public boolean start(AmazonS3 s3, TransferDBUtil dbUtil, TransferStatusUpdater updater, TransferService.NetworkInfoReceiver networkInfo) {
        if (!this.isRunning() && this.checkIsReadyToRun()) {
            if (TransferType.DOWNLOAD.equals((Object)this.record.getType())) {
                LOGGER.info((Object)"Task Download ");
                this.submittedTask = TransferThreadPool.submitTask(new DownloadTask(this, s3, updater, networkInfo));
            } else {
                LOGGER.info((Object)"Task Upload ");
                this.submittedTask = TransferThreadPool.submitTask(new UploadTask(this, s3, dbUtil, updater, networkInfo));
            }
            return true;
        }
        return false;
    }

    public boolean pause(AmazonS3 s3, TransferStatusUpdater updater) {
        if (!this.isFinalState(this.record.getState()) && !TransferState.PAUSED.equals((Object)this.record.getState())) {
            updater.updateState(this.record.getId(), TransferState.PAUSED);
            if (this.isRunning()) {
                this.submittedTask.cancel(true);
            }
            return true;
        }
        return false;
    }

    public boolean cancel(final AmazonS3 s3, TransferStatusUpdater updater) {
        if (!this.isFinalState(this.record.getState())) {
            updater.updateState(this.record.getId(), TransferState.CANCELED);
            if (this.isRunning()) {
                this.submittedTask.cancel(true);
            }
            if (this.record.getIsMultipart() == 1) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            s3.abortMultipartUpload(new AbortMultipartUploadRequest(TransferRecord.this.record.getBucketName(), TransferRecord.this.record.getKey(), TransferRecord.this.record.getMultipartId()));
                            LOGGER.debug((Object)("Successfully clean up multipart upload: " + TransferRecord.this.record.getId()));
                        }
                        catch (AmazonClientException e) {
                            LOGGER.debug((Object)("Failed to abort multiplart upload: " + TransferRecord.this.record.getId()), (Throwable)e);
                        }
                    }
                }).start();
            } else if (TransferType.DOWNLOAD.equals((Object)this.record.getType())) {
                new File(this.record.getFile()).delete();
            }
            return true;
        }
        return false;
    }

    boolean isRunning() {
        return this.submittedTask != null && !this.submittedTask.isDone();
    }

    void waitTillFinish(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isRunning()) {
            this.submittedTask.get(timeout, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isFinalState(TransferState state) {
        return TransferState.COMPLETED.equals((Object)state) || TransferState.FAILED.equals((Object)state) || TransferState.CANCELED.equals((Object)state);
    }

    private boolean checkIsReadyToRun() {
        return this.record.getPartNumber() == 0 && !TransferState.COMPLETED.equals((Object)this.record.getState());
    }

    public Record getRecord() {
        return this.record;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append("id:").append(this.record.getId()).append(",").append("bucketName:").append(this.record.getBucketName()).append(",").append("key:").append(this.record.getKey()).append(",").append("file:").append(this.record.getFile()).append(",").append("type:").append((Object)this.record.getType()).append(",").append("bytesTotal:").append(this.record.getBytesTotal()).append(",").append("bytesCurrent:").append(this.record.getBytesCurrent()).append(",").append("fileOffset:").append(this.record.getFileOffset()).append(",").append("state:").append((Object)this.record.getState()).append(",").append("cannedAcl:").append(this.record.getCannedAcl()).append(",").append("mainUploadId:").append(this.record.getMainUploadId()).append(",").append("isMultipart:").append(this.record.getIsMultipart()).append(",").append("isLastPart:").append(this.record.getIsLastPart()).append(",").append("partNumber:").append(this.record.getPartNumber()).append(",").append("multipartId:").append(this.record.getMultipartId()).append(",").append("eTag:").append(this.record.geteTag()).append("]");
        return sb.toString();
    }
}

