/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.s3.transferutility.Record;
import com.amazonaws.mobileconnectors.s3.transferutility.S3ClientReference;
import com.amazonaws.mobileconnectors.s3.transferutility.Service;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferType;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtilityOptions;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class TransferUtility {
    private static final Logger LOGGER = Logger.getLogger(TransferUtility.class.getName());
    static final int MINIMUM_UPLOAD_PART_SIZE = 0x500000;
    private static String userAgentFromConfig = "";
    private final AmazonS3 s3;
    private final TransferDBUtil dbUtil;
    private final String defaultBucket;
    private final TransferUtilityOptions transferUtilityOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUserAgentFromConfig(String userAgent) {
        String string = userAgentFromConfig;
        synchronized (string) {
            userAgentFromConfig = userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserAgentFromConfig() {
        String string = userAgentFromConfig;
        synchronized (string) {
            if (userAgentFromConfig == null || userAgentFromConfig.trim().isEmpty()) {
                return "";
            }
            return userAgentFromConfig.trim() + "/";
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private TransferUtility(AmazonS3 s3, String defaultBucket, TransferUtilityOptions tuOptions) {
        this.s3 = s3;
        this.dbUtil = new TransferDBUtil();
        this.defaultBucket = defaultBucket;
        this.transferUtilityOptions = tuOptions;
    }

    @Deprecated
    public TransferUtility(AmazonS3 s3) {
        this.s3 = s3;
        this.dbUtil = new TransferDBUtil();
        this.defaultBucket = null;
        this.transferUtilityOptions = new TransferUtilityOptions();
    }

    private String getDefaultBucketOrThrow() {
        if (this.defaultBucket == null) {
            throw new IllegalArgumentException("TransferUtility has not been configured with a default bucket. Please use the corresponding method that specifies bucket name or configure the default bucket name in construction of the object. See TransferUtility.builder().defaultBucket() or TransferUtility.builder().awsConfiguration()");
        }
        return this.defaultBucket;
    }

    public TransferObserver download(String bucket, String key, File file) {
        return this.download(bucket, key, file, null);
    }

    public TransferObserver download(String key, File file) {
        return this.download(this.getDefaultBucketOrThrow(), key, file, null);
    }

    public TransferObserver download(String bucket, String key, File file, TransferListener listener) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        int recordId = this.dbUtil.insertSingleTransferRecord(TransferType.DOWNLOAD, bucket, key, file);
        if (file.isFile()) {
            LOGGER.log(Level.WARNING, "Overwrite existing file: " + file);
            file.delete();
        }
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, bucket, key, file, listener);
    }

    public TransferObserver download(String key, File file, TransferListener listener) {
        return this.download(this.getDefaultBucketOrThrow(), key, file, listener);
    }

    public TransferObserver upload(String bucket, String key, File file) {
        return this.upload(bucket, key, file, new ObjectMetadata());
    }

    public TransferObserver upload(String key, File file) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, new ObjectMetadata());
    }

    public TransferObserver upload(String bucket, String key, File file, CannedAccessControlList cannedAcl) {
        return this.upload(bucket, key, file, new ObjectMetadata(), cannedAcl);
    }

    public TransferObserver upload(String key, File file, CannedAccessControlList cannedAcl) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, new ObjectMetadata(), cannedAcl);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata) {
        return this.upload(bucket, key, file, metadata, null);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, null);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        return this.upload(bucket, key, file, metadata, cannedAcl, null);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, cannedAcl, null);
    }

    public TransferObserver upload(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl, TransferListener listener) {
        if (file == null || file.isDirectory() || !file.exists()) {
            throw new IllegalArgumentException("Invalid file: " + file);
        }
        int recordId = 0;
        recordId = this.shouldUploadInMultipart(file) ? this.createMultipartUploadRecords(bucket, key, file, metadata, cannedAcl) : this.dbUtil.insertSingleTransferRecord(TransferType.UPLOAD, bucket, key, file, metadata, cannedAcl);
        this.sendIntent("add_transfer", recordId);
        return new TransferObserver(recordId, bucket, key, file, listener);
    }

    public TransferObserver upload(String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl, TransferListener listener) {
        return this.upload(this.getDefaultBucketOrThrow(), key, file, metadata, cannedAcl, listener);
    }

    public TransferObserver getTransferById(int id) {
        for (Record r : Service.getInstance().getRecords()) {
            if (r.getId() != id) continue;
            TransferObserver to = new TransferObserver(id);
            to.updateFromDB(r);
            return to;
        }
        return null;
    }

    public List<TransferObserver> getTransfersWithType(TransferType type) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getType().equals((Object)type)) continue;
            TransferObserver to = new TransferObserver(record.getId());
            to.updateFromDB(record);
            transferObservers.add(to);
        }
        return transferObservers;
    }

    public List<TransferObserver> getTransfersWithTypeAndState(TransferType type, TransferState state) {
        return this.getTransfersWithTypeAndStates(type, new TransferState[]{state});
    }

    public List<TransferObserver> getTransfersWithTypeAndStates(TransferType type, TransferState[] states) {
        ArrayList<TransferObserver> transferObservers = new ArrayList<TransferObserver>();
        block0: for (Record record : Service.getInstance().getRecords()) {
            if (!record.getType().equals((Object)type) || record.getMultipartId().equals("0")) continue;
            for (TransferState state : states) {
                if (!record.getState().equals((Object)state)) continue;
                TransferObserver to = new TransferObserver(record.getId());
                to.updateFromDB(record);
                transferObservers.add(to);
                continue block0;
            }
        }
        return transferObservers;
    }

    private List<Integer> getTransferIdsWithTypeAndStates(TransferType type, TransferState[] states) {
        ArrayList<Integer> transferIds = new ArrayList<Integer>();
        block0: for (Record record : Service.getInstance().getRecords()) {
            if (!record.getType().equals((Object)type) || record.getMultipartId().equals("0")) continue;
            for (TransferState state : states) {
                if (!record.getState().equals((Object)state)) continue;
                TransferObserver to = new TransferObserver(record.getId());
                to.updateFromDB(record);
                transferIds.add(to.getId());
                continue block0;
            }
        }
        return transferIds;
    }

    private int createMultipartUploadRecords(String bucket, String key, File file, ObjectMetadata metadata, CannedAccessControlList cannedAcl) {
        long remainingLenth = file.length();
        double partSize = (double)remainingLenth / 10000.0;
        partSize = Math.ceil(partSize);
        long optimalPartSize = (long)Math.max(partSize, 5242880.0);
        long fileOffset = 0L;
        int partNumber = 1;
        int partCount = (int)Math.ceil((double)remainingLenth / (double)optimalPartSize);
        Record[] valuesArray = new Record[partCount + 1];
        valuesArray[0] = this.dbUtil.generateRecordForMultiPartUpload(bucket, key, file, fileOffset, 0, "", file.length(), 0, metadata, cannedAcl);
        for (int i = 1; i < partCount + 1; ++i) {
            long bytesForPart = Math.min(optimalPartSize, remainingLenth);
            valuesArray[i] = this.dbUtil.generateRecordForMultiPartUpload(bucket, key, file, fileOffset, partNumber, "", bytesForPart, remainingLenth - optimalPartSize <= 0L ? 1 : 0, metadata, cannedAcl);
            fileOffset += optimalPartSize;
            remainingLenth -= optimalPartSize;
            ++partNumber;
        }
        return this.dbUtil.bulkInsertTransferRecords(valuesArray);
    }

    public boolean pause(int id) {
        this.sendIntent("pause_transfer", id);
        return true;
    }

    public void pauseAllWithType(TransferType type) {
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getType().equals((Object)type)) continue;
            this.pause(record.getId());
        }
    }

    public TransferObserver resume(int id) {
        this.sendIntent("resume_transfer", id);
        return this.getTransferById(id);
    }

    public List<TransferObserver> resumeAllWithType(TransferType type) {
        ArrayList<TransferObserver> observers = new ArrayList<TransferObserver>();
        List<Integer> transferIds = this.getTransferIdsWithTypeAndStates(type, new TransferState[]{TransferState.PAUSED, TransferState.FAILED, TransferState.CANCELED});
        for (Integer transferId : transferIds) {
            observers.add(this.resume(transferId));
        }
        return observers;
    }

    public boolean cancel(int id) {
        this.sendIntent("cancel_transfer", id);
        return true;
    }

    public void cancelAllWithType(TransferType type) {
        for (Record record : Service.getInstance().getRecords()) {
            if (!record.getType().equals((Object)type)) continue;
            this.cancel(record.getId());
        }
    }

    public boolean deleteTransferRecord(int id) {
        this.cancel(id);
        return this.dbUtil.deleteTransferRecords(id) > 0;
    }

    private synchronized void sendIntent(String action, int id) {
        S3ClientReference.put(id, this.s3);
        TransferService service = new TransferService();
        LOGGER.log(Level.INFO, "Sending action intent: " + action + " for id " + id);
        service.onStartCommand(action, id, this.transferUtilityOptions, id, id);
    }

    private boolean shouldUploadInMultipart(File file) {
        return file != null && file.length() > 0x500000L;
    }

    static <X extends AmazonWebServiceRequest> X appendTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService/" + TransferUtility.getUserAgentFromConfig() + VersionInfoUtils.getVersion());
        return request;
    }

    static <X extends AmazonWebServiceRequest> X appendMultipartTransferServiceUserAgentString(X request) {
        request.getRequestClientOptions().appendUserAgent("TransferService_multipart/" + TransferUtility.getUserAgentFromConfig() + VersionInfoUtils.getVersion());
        return request;
    }

    TransferDBUtil getDbUtil() {
        return this.dbUtil;
    }

    public static class Builder {
        private AmazonS3 s3;
        private String defaultBucket;
        private AWSConfiguration awsConfig;
        private TransferUtilityOptions transferUtilityOptions;

        protected Builder() {
        }

        public Builder s3Client(AmazonS3 s3Client) {
            this.s3 = s3Client;
            return this;
        }

        public Builder defaultBucket(String bucket) {
            this.defaultBucket = bucket;
            return this;
        }

        public Builder awsConfiguration(AWSConfiguration awsConfiguration) {
            this.awsConfig = awsConfiguration;
            return this;
        }

        public Builder transferUtilityOptions(TransferUtilityOptions tuOptions) {
            this.transferUtilityOptions = tuOptions;
            return this;
        }

        public TransferUtility build() {
            if (this.s3 == null) {
                throw new IllegalArgumentException("AmazonS3 client is required please set using .s3Client(yourClient)");
            }
            if (this.awsConfig != null) {
                try {
                    JSONObject tuConfig = this.awsConfig.optJsonObject("S3TransferUtility");
                    this.s3.setRegion(Region.getRegion((String)tuConfig.getString("Region")));
                    this.defaultBucket = tuConfig.getString("Bucket");
                    TransferUtility.setUserAgentFromConfig(this.awsConfig.getUserAgent());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read S3TransferUtility please check your setup or awsconfiguration.json file", e);
                }
            }
            if (this.transferUtilityOptions == null) {
                this.transferUtilityOptions = new TransferUtilityOptions();
            }
            return new TransferUtility(this.s3, this.defaultBucket, this.transferUtilityOptions);
        }
    }
}

