/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.s3.transferutility;

import com.amazonaws.AmazonClientException;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferDBUtil;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferRecord;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferService;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferStatusUpdater;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferThreadPool;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.mobileconnectors.s3.transferutility.UploadPartTask;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.util.Mimetypes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class UploadTask
implements Callable<Boolean> {
    private static final Log LOGGER = LogFactory.getLog(UploadTask.class);
    private final AmazonS3 s3;
    private final TransferRecord upload;
    private final TransferDBUtil dbUtil;
    private final TransferStatusUpdater updater;
    private final TransferService.NetworkInfoReceiver networkInfo;
    private static final Map<String, CannedAccessControlList> CANNED_ACL_MAP = new HashMap<String, CannedAccessControlList>();

    public UploadTask(TransferRecord uploadInfo, AmazonS3 s3, TransferDBUtil dbUtil, TransferStatusUpdater updater, TransferService.NetworkInfoReceiver networkInfo) {
        this.upload = uploadInfo;
        this.s3 = s3;
        this.dbUtil = dbUtil;
        this.updater = updater;
        this.networkInfo = networkInfo;
    }

    @Override
    public Boolean call() throws Exception {
        LOGGER.info((Object)("CALL Upload Task " + this.networkInfo.isNetworkConnected()));
        if (!this.networkInfo.isNetworkConnected()) {
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
            LOGGER.info((Object)"Upload Task not connected - false");
            return false;
        }
        LOGGER.info((Object)"Upload Task state progress");
        this.updater.updateState(this.upload.getRecord().getId(), TransferState.IN_PROGRESS);
        LOGGER.info((Object)("Upload Task - multipart " + this.upload.getRecord().getIsMultipart()));
        if (this.upload.getRecord().getIsMultipart() == 1 && this.upload.getRecord().getPartNumber() == 0) {
            return this.uploadMultipartAndWaitForCompletion();
        }
        if (this.upload.getRecord().getIsMultipart() == 0) {
            return this.uploadSinglePartAndWaitForCompletion();
        }
        return false;
    }

    private Boolean uploadMultipartAndWaitForCompletion() throws ExecutionException {
        long bytesAlreadyTransferrd = 0L;
        if (this.upload.getRecord().getMultipartId() == null || this.upload.getRecord().getMultipartId().isEmpty()) {
            PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
            TransferUtility.appendMultipartTransferServiceUserAgentString(putObjectRequest);
            try {
                this.upload.getRecord().setMultipartId(this.initiateMultipartUpload(putObjectRequest));
            }
            catch (AmazonClientException ace) {
                LOGGER.error((Object)("Error initiating multipart upload: " + this.upload.getRecord().getId() + " due to " + ace.getMessage()), (Throwable)ace);
                this.updater.throwError(this.upload.getRecord().getId(), (Exception)((Object)ace));
                this.updater.updateState(this.upload.getRecord().getId(), TransferState.FAILED);
                return false;
            }
            this.dbUtil.updateMultipartId(this.upload.getRecord().getId(), this.upload.getRecord().getMultipartId());
        } else {
            bytesAlreadyTransferrd = this.dbUtil.queryBytesTransferredByMainUploadId(this.upload.getRecord().getId());
            if (bytesAlreadyTransferrd > 0L) {
                LOGGER.debug((Object)String.format("Resume transfer %d from %d bytes", this.upload.getRecord().getId(), bytesAlreadyTransferrd));
            }
        }
        this.updater.updateProgress(this.upload.getRecord().getId(), bytesAlreadyTransferrd, this.upload.getRecord().getBytesTotal());
        List<UploadPartRequest> requestList = this.dbUtil.getNonCompletedPartRequestsFromDB(this.upload.getRecord().getId(), this.upload.getRecord().getMultipartId());
        LOGGER.debug((Object)("multipart upload " + this.upload.getRecord().getId() + " in " + requestList.size() + " parts."));
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (UploadPartRequest uploadPartRequest : requestList) {
            TransferUtility.appendMultipartTransferServiceUserAgentString(uploadPartRequest);
            uploadPartRequest.setGeneralProgressListener(this.updater.newProgressListener(this.upload.getRecord().getId()));
            futures.add(TransferThreadPool.submitTask(new UploadPartTask(uploadPartRequest, this.s3, this.dbUtil, this.networkInfo)));
        }
        try {
            boolean isSuccess = true;
            for (Future future : futures) {
                boolean b = (Boolean)future.get();
                isSuccess &= b;
            }
            if (!isSuccess) {
                return false;
            }
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            LOGGER.debug((Object)("Transfer " + this.upload.getRecord().getId() + " is interrupted by user"));
            return false;
        }
        catch (ExecutionException ee) {
            boolean bl = false;
            if (ee.getCause() != null && ee.getCause() instanceof Exception) {
                boolean bl2 = this.dbUtil.checkWaitingForNetworkPartRequestsFromDB(this.upload.getRecord().getId());
                if (bl2) {
                    LOGGER.debug((Object)("Network Connection Interrupted: Transfer " + this.upload.getRecord().getId() + " waits for network"));
                    this.updater.updateState(this.upload.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
                    return false;
                }
                Exception exception = (Exception)ee.getCause();
                if (RetryUtils.isInterrupted((Throwable)exception)) {
                    LOGGER.debug((Object)("Transfer " + this.upload.getRecord().getId() + " is interrupted by user"));
                    return false;
                }
                if (exception.getCause() != null && exception.getCause() instanceof IOException && !this.networkInfo.isNetworkConnected()) {
                    LOGGER.debug((Object)("Transfer " + this.upload.getRecord().getId() + " waits for network"));
                    this.updater.updateState(this.upload.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
                }
                this.updater.throwError(this.upload.getRecord().getId(), exception);
            }
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.FAILED);
            return false;
        }
        try {
            this.completeMultiPartUpload(this.upload.getRecord().getId(), this.upload.getRecord().getBucketName(), this.upload.getRecord().getKey(), this.upload.getRecord().getMultipartId());
            this.updater.updateProgress(this.upload.getRecord().getId(), this.upload.getRecord().getBytesTotal(), this.upload.getRecord().getBytesTotal());
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.COMPLETED);
            return true;
        }
        catch (AmazonClientException ace) {
            LOGGER.error((Object)("Failed to complete multipart: " + this.upload.getRecord().getId() + " due to " + ace.getMessage()), (Throwable)ace);
            this.updater.throwError(this.upload.getRecord().getId(), (Exception)((Object)ace));
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.FAILED);
            return false;
        }
    }

    private Boolean uploadSinglePartAndWaitForCompletion() {
        LOGGER.info((Object)"Upload single part");
        PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.upload);
        long length = putObjectRequest.getFile().length();
        LOGGER.info((Object)("length single part: " + length));
        TransferUtility.appendTransferServiceUserAgentString(putObjectRequest);
        this.updater.updateProgress(this.upload.getRecord().getId(), 0L, length);
        putObjectRequest.setGeneralProgressListener(this.updater.newProgressListener(this.upload.getRecord().getId()));
        try {
            this.s3.putObject(putObjectRequest);
            this.updater.updateProgress(this.upload.getRecord().getId(), length, length);
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.COMPLETED);
            return true;
        }
        catch (Exception e) {
            if (RetryUtils.isInterrupted((Throwable)e)) {
                LOGGER.debug((Object)("Transfer " + this.upload.getRecord().getId() + " is interrupted by user"));
                return false;
            }
            if (e.getCause() != null && e.getCause() instanceof AmazonClientException && !this.networkInfo.isNetworkConnected()) {
                LOGGER.debug((Object)("Network Connection Interrupted: Transfer " + this.upload.getRecord().getId() + " waits for network"));
                this.updater.updateState(this.upload.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
                return false;
            }
            if (e.getCause() != null && e.getCause() instanceof IOException && !this.networkInfo.isNetworkConnected()) {
                LOGGER.debug((Object)("Transfer " + this.upload.getRecord().getId() + " waits for network"));
                this.updater.updateState(this.upload.getRecord().getId(), TransferState.WAITING_FOR_NETWORK);
            }
            LOGGER.debug((Object)("Failed to upload: " + this.upload.getRecord().getId() + " due to " + e.getMessage()), (Throwable)e);
            this.updater.throwError(this.upload.getRecord().getId(), e);
            this.updater.updateState(this.upload.getRecord().getId(), TransferState.FAILED);
            return false;
        }
    }

    private void completeMultiPartUpload(int mainUploadId, String bucket, String key, String multipartId) {
        List<PartETag> partETags = this.dbUtil.queryPartETagsOfUpload(mainUploadId);
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucket, key, multipartId, partETags);
        TransferUtility.appendMultipartTransferServiceUserAgentString(completeRequest);
        this.s3.completeMultipartUpload(completeRequest);
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = null;
        initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata()).withSSEAwsKeyManagementParams(putObjectRequest.getSSEAwsKeyManagementParams());
        TransferUtility.appendMultipartTransferServiceUserAgentString(initiateMultipartUploadRequest);
        String uploadId = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        return uploadId;
    }

    private PutObjectRequest createPutObjectRequest(TransferRecord upload) {
        File file = new File(upload.getRecord().getFile());
        PutObjectRequest putObjectRequest = new PutObjectRequest(upload.getRecord().getBucketName(), upload.getRecord().getKey(), file);
        ObjectMetadata om = new ObjectMetadata();
        om.setContentLength(file.length());
        if (upload.getRecord().getHeaderCacheControl() != null) {
            om.setCacheControl(upload.getRecord().getHeaderCacheControl());
        }
        if (upload.getRecord().getHeaderContentDisposition() != null) {
            om.setContentDisposition(upload.getRecord().getHeaderContentDisposition());
        }
        if (upload.getRecord().getHeaderContentEncoding() != null) {
            om.setContentEncoding(upload.getRecord().getHeaderContentEncoding());
        }
        if (upload.getRecord().getHeaderContentType() != null) {
            om.setContentType(upload.getRecord().getHeaderContentType());
        } else {
            om.setContentType(Mimetypes.getInstance().getMimetype(file));
        }
        if (upload.getRecord().getExpirationTimeRuleId() != null) {
            om.setExpirationTimeRuleId(upload.getRecord().getExpirationTimeRuleId());
        }
        if (upload.getRecord().getHttpExpires() != null) {
            om.setHttpExpiresDate(new Date(Long.valueOf(upload.getRecord().getHttpExpires())));
        }
        if (upload.getRecord().getSseAlgorithm() != null) {
            om.setSSEAlgorithm(upload.getRecord().getSseAlgorithm());
        }
        if (upload.getRecord().getUserMetadata() != null) {
            om.setUserMetadata(upload.getRecord().getUserMetadata());
        }
        if (upload.getRecord().getMd5() != null) {
            om.setContentMD5(upload.getRecord().getMd5());
        }
        if (upload.getRecord().getSseKMSKey() != null) {
            putObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(upload.getRecord().getSseKMSKey()));
        }
        putObjectRequest.setMetadata(om);
        putObjectRequest.setCannedAcl(UploadTask.getCannedAclFromString(upload.getRecord().getCannedAcl()));
        return putObjectRequest;
    }

    private static CannedAccessControlList getCannedAclFromString(String cannedAcl) {
        return cannedAcl == null ? null : CANNED_ACL_MAP.get(cannedAcl);
    }

    static {
        for (CannedAccessControlList cannedAcl : CannedAccessControlList.values()) {
            CANNED_ACL_MAP.put(cannedAcl.toString(), cannedAcl);
        }
    }
}

