/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down;

import com.gluonhq.charm.down.Platform;
import com.gluonhq.charm.down.ServiceFactory;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DefaultServiceFactory<T>
implements ServiceFactory<T> {
    private final Class<T> serviceType;
    private T instance;

    public DefaultServiceFactory(Class<T> serviceType) {
        this.serviceType = serviceType;
    }

    @Override
    public Class<T> getServiceType() {
        return this.serviceType;
    }

    @Override
    public Optional<T> getInstance() {
        if (this.instance == null) {
            this.instance = this.createInstance(Platform.getCurrent());
        }
        return Optional.ofNullable(this.instance);
    }

    private T createInstance(Platform platform) {
        String fqn = "com.gluonhq.charm.down.plugins." + platform.name().toLowerCase(Locale.ROOT) + "." + platform.getName() + this.serviceType.getSimpleName();
        try {
            Class<?> clazz = Class.forName(fqn);
            if (clazz != null) {
                return (T)clazz.newInstance();
            }
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DefaultServiceFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DefaultServiceFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

