/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum Platform {
    DESKTOP("Desktop"),
    ANDROID("Android"),
    IOS("IOS");

    private final String javafxPlatformName;
    private static final Platform current;

    private Platform(String javafxPlatformName) {
        this.javafxPlatformName = javafxPlatformName;
    }

    public static final Platform getCurrent() {
        return current;
    }

    public static final boolean isDesktop() {
        return DESKTOP == current;
    }

    public static final boolean isAndroid() {
        return ANDROID == current;
    }

    public static final boolean isIOS() {
        return IOS == current;
    }

    String getName() {
        return this.javafxPlatformName;
    }

    static {
        String s = System.getProperty("javafx.platform", null);
        if (s == null) {
            Logger.getLogger(Platform.class.getName()).log(Level.SEVERE, "javafx.platform is not defined. Desktop will be assumed by default.");
            s = DESKTOP.getName();
        }
        current = Platform.valueOf(s.toUpperCase(Locale.ROOT));
    }
}

