/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.down.plugins;

import com.gluonhq.charm.down.Services;
import com.gluonhq.charm.down.plugins.LocalNotificationsService;
import com.gluonhq.charm.down.plugins.Notification;
import com.gluonhq.charm.down.plugins.RuntimeArgsService;
import com.gluonhq.impl.charm.down.plugins.NotificationsManager;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class LocalNotificationsServiceBase
implements LocalNotificationsService {
    private static final Logger LOGGER = Logger.getLogger(LocalNotificationsServiceBase.class.getName());
    private final ObservableList<Notification> notifications = FXCollections.observableArrayList();

    public LocalNotificationsServiceBase() {
        this.notifications.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    for (Notification n : c.getAddedSubList()) {
                        try {
                            boolean needsScheduling = NotificationsManager.registerNotification(n);
                            if (!needsScheduling) continue;
                            this.scheduleNotification(n);
                        }
                        catch (Exception e) {
                            LOGGER.severe("Registering a notification created a (non-fatal) exception.");
                            e.printStackTrace();
                        }
                    }
                } else if (c.wasRemoved()) {
                    for (Notification n : c.getRemoved()) {
                        this.unscheduleNotification(NotificationsManager.unregisterNotification(n.getId()));
                    }
                }
                Services.get(RuntimeArgsService.class).ifPresent(service -> {
                    service.removeListener("Launch.LocalNotification");
                    service.addListener("Launch.LocalNotification", NotificationsManager::processNotification);
                });
            }
        });
    }

    @Override
    public final ObservableList<Notification> getNotifications() {
        return this.notifications;
    }

    protected abstract void scheduleNotification(Notification var1);

    protected abstract void unscheduleNotification(Notification var1);
}

