/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.down.plugins;

import com.gluonhq.charm.down.plugins.Notification;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;

public class NotificationsManager {
    private static final Map<String, Notification> NOTIFICATION_MAP = new HashMap<String, Notification>();

    public static void processNotification(String id) {
        Runnable runnable;
        if (NOTIFICATION_MAP.containsKey(id) && (runnable = NOTIFICATION_MAP.remove(id).getRunnable()) != null) {
            Platform.runLater(runnable::run);
        }
    }

    public static boolean registerNotification(Notification n) {
        if (n == null || n.getId() == null) {
            return false;
        }
        if (NOTIFICATION_MAP.containsKey(n.getId())) {
            Notification m = NOTIFICATION_MAP.get(n.getId());
            if (m.getDateTime() != null && !m.getDateTime().equals(n.getDateTime()) || m.getTitle() != null && !m.getTitle().equals(n.getTitle()) || m.getText() != null && !m.getText().equals(n.getText())) {
                throw new IllegalArgumentException("Error trying to schedule a new notification with an existing ID");
            }
            if (m.getDateTime() != null && m.getText() != null && !m.getText().isEmpty()) {
                return false;
            }
        }
        NOTIFICATION_MAP.put(n.getId(), n);
        return n.getDateTime() != null && n.getText() != null && !n.getText().isEmpty();
    }

    public static Notification unregisterNotification(String id) {
        return NOTIFICATION_MAP.remove(id);
    }
}

