/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect;

import com.gluonhq.connect.ConnectState;
import com.gluonhq.connect.ConnectStateEvent;
import com.gluonhq.connect.GluonObservable;
import com.gluonhq.impl.connect.EventHelper;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;

public class GluonObservableList<E>
extends ModifiableObservableListBase<E>
implements GluonObservable,
ObservableList<E> {
    private final BooleanProperty initialized = new SimpleBooleanProperty((Object)this, "initialized", false);
    private final ObjectProperty<ConnectState> state = new SimpleObjectProperty((Object)this, "state", (Object)ConnectState.READY);
    private final ObjectProperty<Throwable> exception = new SimpleObjectProperty((Object)this, "exception");
    private final ObservableList<E> backing = FXCollections.observableArrayList();
    private final SortedList<E> backingSorted = new SortedList(this.backing);
    private EventHelper eventHelper = null;

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public ReadOnlyBooleanProperty initializedProperty() {
        return this.initialized;
    }

    @Override
    public ConnectState getState() {
        return (ConnectState)((Object)this.state.get());
    }

    public void setState(ConnectState state) {
        ConnectState s = this.getState();
        if (s != ConnectState.CANCELLED) {
            this.state.set((Object)state);
            switch ((ConnectState)((Object)this.state.get())) {
                case CANCELLED: {
                    this.fireEvent(new ConnectStateEvent(this, ConnectStateEvent.CONNECT_STATE_CANCELLED));
                    break;
                }
                case FAILED: {
                    this.fireEvent(new ConnectStateEvent(this, ConnectStateEvent.CONNECT_STATE_FAILED));
                    break;
                }
                case READY: {
                    break;
                }
                case RUNNING: {
                    this.fireEvent(new ConnectStateEvent(this, ConnectStateEvent.CONNECT_STATE_RUNNING));
                    break;
                }
                case REMOVED: {
                    this.fireEvent(new ConnectStateEvent(this, ConnectStateEvent.CONNECT_STATE_REMOVED));
                    break;
                }
                case SUCCEEDED: {
                    this.fireEvent(new ConnectStateEvent(this, ConnectStateEvent.CONNECT_STATE_SUCCEEDED));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should be unreachable");
                }
            }
        }
    }

    @Override
    public ReadOnlyObjectProperty<ConnectState> stateProperty() {
        return this.state;
    }

    @Override
    public Throwable getException() {
        return (Throwable)this.exception.get();
    }

    public void setException(Throwable exception) {
        this.exception.set((Object)exception);
    }

    @Override
    public ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        return this.exception;
    }

    @Override
    public void setOnReady(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnReady(value);
    }

    @Override
    public void setOnRunning(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnRunning(value);
    }

    @Override
    public void setOnFailed(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnFailed(value);
    }

    @Override
    public void setOnSucceeded(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnSucceeded(value);
    }

    @Override
    public void setOnCancelled(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnCancelled(value);
    }

    @Override
    public void setOnRemoved(EventHandler<ConnectStateEvent> value) {
        this.getEventHelper().setOnRemoved(value);
    }

    public E get(int index) {
        return (E)this.backingSorted.get(index);
    }

    public int size() {
        return this.backing.size();
    }

    protected void doAdd(int index, E element) {
        this.backing.add(index, element);
    }

    protected E doSet(int index, E element) {
        return (E)this.backing.set(index, element);
    }

    protected E doRemove(int index) {
        return (E)this.backing.remove(index);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return this.getEventHelper().buildEventDispatchChain(tail);
    }

    private void fireEvent(ConnectStateEvent event) {
        this.getEventHelper().fireEvent(event);
    }

    private EventHelper getEventHelper() {
        if (this.eventHelper == null) {
            this.eventHelper = new EventHelper(this);
        }
        return this.eventHelper;
    }
}

