/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.converter;

import com.gluonhq.impl.connect.converter.ClassInspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonConverter<T> {
    private static final Logger LOGGER = Logger.getLogger(JsonConverter.class.getName());
    private static final JsonBuilderFactory builderFactory = Json.createBuilderFactory(null);
    private final Class<T> targetClass;
    private final ClassInspector<T> inspector;

    public JsonConverter(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.inspector = ClassInspector.resolve(targetClass);
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public T readFromJson(JsonObject json) {
        T t = null;
        try {
            if (!Map.class.isAssignableFrom(this.targetClass)) {
                t = this.targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.WARNING, "Map not yet supported");
            }
            Map<String, Method> settersMappedByPropertyName = this.inspector.getSetters();
            if (settersMappedByPropertyName != null) {
                for (String property : settersMappedByPropertyName.keySet()) {
                    if (!json.containsKey((Object)property)) {
                        LOGGER.log(Level.FINEST, "Property " + property + " not defined on json object for class " + this.targetClass + ".");
                        continue;
                    }
                    if (!json.containsKey((Object)property)) continue;
                    Method setter = settersMappedByPropertyName.get(property);
                    Class<?> parameterType = setter.getParameterTypes()[0];
                    Object[] args = new Object[1];
                    JsonValue jsonValue = (JsonValue)json.get((Object)property);
                    switch (jsonValue.getValueType()) {
                        case NULL: {
                            args[0] = null;
                            break;
                        }
                        case FALSE: {
                            args[0] = Boolean.FALSE;
                            break;
                        }
                        case TRUE: {
                            args[0] = Boolean.TRUE;
                            break;
                        }
                        case STRING: {
                            JsonString stringProperty = (JsonString)jsonValue;
                            if (parameterType.isEnum()) {
                                args[0] = Enum.valueOf(parameterType.asSubclass(Enum.class), stringProperty.getString());
                                break;
                            }
                            args[0] = stringProperty.getString();
                            break;
                        }
                        case NUMBER: {
                            String setterParameterTypeName;
                            JsonNumber numberProperty = (JsonNumber)jsonValue;
                            Class<?> setterParameterType = setter.getParameterTypes()[0];
                            if (setterParameterType.isArray()) break;
                            switch (setterParameterTypeName = setterParameterType.getName()) {
                                case "byte": 
                                case "java.lang.Byte": 
                                case "int": 
                                case "java.lang.Integer": 
                                case "short": 
                                case "java.lang.Short": {
                                    args[0] = numberProperty.intValue();
                                    break;
                                }
                                case "long": 
                                case "java.lang.Long": {
                                    args[0] = numberProperty.longValue();
                                    break;
                                }
                                case "double": 
                                case "java.lang.Double": {
                                    args[0] = numberProperty.doubleValue();
                                    break;
                                }
                                case "float": 
                                case "java.lang.Float": {
                                    args[0] = Float.valueOf((float)numberProperty.doubleValue());
                                    break;
                                }
                                case "java.lang.String": 
                                case "javafx.beans.property.StringProperty": {
                                    args[0] = numberProperty.toString();
                                    break;
                                }
                                case "java.math.BigDecimal": {
                                    args[0] = numberProperty.bigDecimalValue();
                                    break;
                                }
                                case "java.math.BigInteger": {
                                    args[0] = numberProperty.bigIntegerValue();
                                }
                            }
                            break;
                        }
                        case ARRAY: {
                            JsonArray arrayProperty = (JsonArray)jsonValue;
                            Object values = ObservableList.class.isAssignableFrom(parameterType) ? FXCollections.observableArrayList() : new ArrayList();
                            for (JsonValue arrayValue : arrayProperty) {
                                switch (arrayValue.getValueType()) {
                                    case NULL: {
                                        values.add(null);
                                        break;
                                    }
                                    case FALSE: {
                                        values.add(Boolean.FALSE);
                                        break;
                                    }
                                    case TRUE: {
                                        values.add(Boolean.TRUE);
                                        break;
                                    }
                                    case STRING: {
                                        JsonString stringArrayValue = (JsonString)arrayValue;
                                        values.add(stringArrayValue.getString());
                                        break;
                                    }
                                    case NUMBER: {
                                        ParameterizedType listType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                                        Class listClass = (Class)listType.getActualTypeArguments()[0];
                                        JsonNumber numberArrayValue = (JsonNumber)arrayValue;
                                        switch (listClass.getName()) {
                                            case "byte": 
                                            case "java.lang.Byte": 
                                            case "int": 
                                            case "java.lang.Integer": 
                                            case "short": 
                                            case "java.lang.Short": {
                                                values.add(numberArrayValue.intValue());
                                                break;
                                            }
                                            case "long": 
                                            case "java.lang.Long": {
                                                values.add(numberArrayValue.longValue());
                                                break;
                                            }
                                            case "double": 
                                            case "java.lang.Double": {
                                                values.add(numberArrayValue.doubleValue());
                                                break;
                                            }
                                            case "float": 
                                            case "java.lang.Float": {
                                                values.add(Float.valueOf((float)numberArrayValue.doubleValue()));
                                                break;
                                            }
                                            case "java.lang.String": 
                                            case "javafx.beans.property.StringProperty": {
                                                values.add(numberArrayValue.toString());
                                                break;
                                            }
                                            case "java.math.BigDecimal": {
                                                values.add(numberArrayValue.bigDecimalValue());
                                                break;
                                            }
                                            case "java.math.BigInteger": {
                                                values.add(numberArrayValue.bigIntegerValue());
                                            }
                                        }
                                        if (numberArrayValue.isIntegral()) {
                                            values.add(numberArrayValue.longValue());
                                            break;
                                        }
                                        values.add(numberArrayValue.doubleValue());
                                        break;
                                    }
                                    case ARRAY: {
                                        LOGGER.log(Level.WARNING, "Arrays within arrays not yet supported.");
                                        break;
                                    }
                                    case OBJECT: {
                                        ParameterizedType listType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                                        Class listClass = (Class)listType.getActualTypeArguments()[0];
                                        JsonConverter<T> jsonConverter = new JsonConverter<T>(listClass);
                                        values.add(jsonConverter.readFromJson((JsonObject)arrayValue));
                                        break;
                                    }
                                }
                            }
                            args[0] = values;
                            break;
                        }
                        case OBJECT: {
                            JsonObject jsonObject = (JsonObject)jsonValue;
                            if (Map.class.isAssignableFrom(parameterType) && jsonObject.containsKey((Object)"entry")) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                JsonValue jsonEntry = (JsonValue)jsonObject.get((Object)"entry");
                                if (jsonEntry.getValueType() == JsonValue.ValueType.ARRAY) {
                                    JsonArray jsonEntryArray = (JsonArray)jsonEntry;
                                    block114: for (int i = 0; i < jsonEntryArray.size(); ++i) {
                                        JsonObject jsonEntryValueObject;
                                        JsonValue jsonEntryValue = (JsonValue)jsonEntryArray.get(i);
                                        if (jsonEntryValue.getValueType() != JsonValue.ValueType.OBJECT || !(jsonEntryValueObject = (JsonObject)jsonEntryValue).containsKey((Object)"key") || !jsonEntryValueObject.containsKey((Object)"value")) continue;
                                        String key = jsonEntryValueObject.getString("key");
                                        JsonValue value = (JsonValue)jsonEntryValueObject.get((Object)"value");
                                        switch (value.getValueType()) {
                                            case NULL: {
                                                map.put(key, null);
                                                continue block114;
                                            }
                                            case FALSE: {
                                                map.put(key, Boolean.FALSE);
                                                continue block114;
                                            }
                                            case TRUE: {
                                                map.put(key, Boolean.TRUE);
                                                continue block114;
                                            }
                                            case STRING: {
                                                map.put(key, ((JsonString)value).getString());
                                                continue block114;
                                            }
                                            case NUMBER: {
                                                String setterParameterTypeName;
                                                JsonNumber valueNumber = (JsonNumber)value;
                                                ParameterizedType mapType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                                                Class mapValueClass = (Class)mapType.getActualTypeArguments()[1];
                                                switch (setterParameterTypeName = mapValueClass.getName()) {
                                                    case "byte": 
                                                    case "java.lang.Byte": 
                                                    case "int": 
                                                    case "java.lang.Integer": 
                                                    case "short": 
                                                    case "java.lang.Short": {
                                                        map.put(key, valueNumber.intValue());
                                                        break;
                                                    }
                                                    case "long": 
                                                    case "java.lang.Long": {
                                                        map.put(key, valueNumber.longValue());
                                                        break;
                                                    }
                                                    case "double": 
                                                    case "java.lang.Double": {
                                                        map.put(key, valueNumber.doubleValue());
                                                        break;
                                                    }
                                                    case "float": 
                                                    case "java.lang.Float": {
                                                        map.put(key, Float.valueOf((float)valueNumber.doubleValue()));
                                                        break;
                                                    }
                                                    case "java.lang.String": 
                                                    case "javafx.beans.property.StringProperty": {
                                                        map.put(key, valueNumber.toString());
                                                        break;
                                                    }
                                                    case "java.math.BigDecimal": {
                                                        map.put(key, valueNumber.bigDecimalValue());
                                                        break;
                                                    }
                                                    case "java.math.BigInteger": {
                                                        map.put(key, valueNumber.bigIntegerValue());
                                                    }
                                                }
                                                continue block114;
                                            }
                                            case ARRAY: {
                                                LOGGER.log(Level.WARNING, "Arrays within maps not yet supported.");
                                                continue block114;
                                            }
                                            case OBJECT: {
                                                ParameterizedType mapType = (ParameterizedType)setter.getGenericParameterTypes()[0];
                                                Class mapValueClass = (Class)mapType.getActualTypeArguments()[1];
                                                JsonConverter<T> jsonConverter = new JsonConverter<T>(mapValueClass);
                                                map.put(key, jsonConverter.readFromJson((JsonObject)value));
                                                continue block114;
                                            }
                                        }
                                    }
                                } else {
                                    JsonConverter jsonConverter = new JsonConverter(parameterType);
                                    args[0] = jsonConverter.readFromJson(jsonObject);
                                }
                                args[0] = map;
                                break;
                            }
                            JsonConverter jsonConverter = new JsonConverter(parameterType);
                            args[0] = jsonConverter.readFromJson(jsonObject);
                        }
                    }
                    try {
                        setter.invoke(t, args);
                    }
                    catch (IllegalArgumentException | InvocationTargetException ex) {
                        LOGGER.log(Level.WARNING, "Failed to call setter " + setter + " with value " + property, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create object of type " + this.targetClass + " from the following json object " + json, ex);
        }
        return t;
    }

    public JsonObject writeToJson(T t) {
        JsonObjectBuilder jsonObjectBuilder = builderFactory.createObjectBuilder();
        Map<String, Method> getters = this.inspector.getGetters();
        if (getters != null) {
            for (String property : getters.keySet()) {
                Method getter = getters.get(property);
                try {
                    this.writeProperty(jsonObjectBuilder, property, getter, t);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    LOGGER.log(Level.WARNING, "Failed to call getter " + getter + " on object " + t, ex);
                }
            }
        }
        return jsonObjectBuilder.build();
    }

    private void writeProperty(JsonObjectBuilder jsonObjectBuilder, String property, Method method, T target) throws IllegalAccessException, InvocationTargetException {
        Object value = method.invoke(target, new Object[0]);
        if (Boolean.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, ((Boolean)value).booleanValue());
        } else if (Boolean.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, ((Boolean)value).booleanValue());
            }
        } else if (Byte.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, (int)((Byte)value).byteValue());
        } else if (Byte.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (int)((Byte)value).byteValue());
            }
        } else if (Double.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, ((Double)value).doubleValue());
        } else if (Double.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, ((Double)value).doubleValue());
            }
        } else if (Float.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, (double)((Float)value).floatValue());
        } else if (Float.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (double)((Float)value).floatValue());
            }
        } else if (Integer.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, ((Integer)value).intValue());
        } else if (Integer.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, ((Integer)value).intValue());
            }
        } else if (Long.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, ((Long)value).longValue());
        } else if (Long.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, ((Long)value).longValue());
            }
        } else if (Short.TYPE.equals(method.getReturnType())) {
            jsonObjectBuilder.add(property, (int)((Short)value).shortValue());
        } else if (Short.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (int)((Short)value).shortValue());
            }
        } else if (String.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (String)value);
            }
        } else if (BigDecimal.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (BigDecimal)value);
            }
        } else if (BigInteger.class.equals(method.getReturnType())) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, (BigInteger)value);
            }
        } else if (List.class.isAssignableFrom(method.getReturnType())) {
            List list = (List)value;
            if (list != null) {
                ParameterizedType listType = (ParameterizedType)method.getGenericReturnType();
                Class listClass = (Class)listType.getActualTypeArguments()[0];
                JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
                for (Object item : list) {
                    this.writeProperty(jsonArrayBuilder, listClass, item);
                }
                jsonObjectBuilder.add(property, jsonArrayBuilder);
            } else {
                jsonObjectBuilder.addNull(property);
            }
        } else if (ObservableList.class.isAssignableFrom(method.getReturnType())) {
            ObservableList list = (ObservableList)value;
            if (list != null) {
                ParameterizedType listType = (ParameterizedType)method.getGenericReturnType();
                Class listClass = (Class)listType.getActualTypeArguments()[0];
                JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
                for (Object item : list) {
                    this.writeProperty(jsonArrayBuilder, listClass, item);
                }
                jsonObjectBuilder.add(property, jsonArrayBuilder);
            } else {
                jsonObjectBuilder.addNull(property);
            }
        } else if (Map.class.isAssignableFrom(method.getReturnType())) {
            Map map = (Map)value;
            if (map != null) {
                ParameterizedType mapType = (ParameterizedType)method.getGenericReturnType();
                Class mapValueClass = (Class)mapType.getActualTypeArguments()[1];
                JsonArrayBuilder jsonArrayBuilder = builderFactory.createArrayBuilder();
                for (Object key : map.keySet()) {
                    JsonObjectBuilder entryJsonObjectBuilder = builderFactory.createObjectBuilder().add("key", key.toString());
                    this.writeProperty(entryJsonObjectBuilder, "value", mapValueClass, map.get(key));
                    jsonArrayBuilder.add(entryJsonObjectBuilder);
                }
                jsonObjectBuilder.add(property, builderFactory.createObjectBuilder().add("entry", jsonArrayBuilder));
            } else {
                jsonObjectBuilder.addNull(property);
            }
        } else if (BooleanProperty.class.equals(method.getReturnType())) {
            BooleanProperty booleanProperty = (BooleanProperty)value;
            if (booleanProperty != null) {
                jsonObjectBuilder.add(property, booleanProperty.get());
            }
        } else if (DoubleProperty.class.equals(method.getReturnType())) {
            DoubleProperty doubleProperty = (DoubleProperty)value;
            if (doubleProperty != null) {
                jsonObjectBuilder.add(property, doubleProperty.get());
            }
        } else if (FloatProperty.class.equals(method.getReturnType())) {
            FloatProperty floatProperty = (FloatProperty)value;
            if (floatProperty != null) {
                jsonObjectBuilder.add(property, (double)floatProperty.get());
            }
        } else if (IntegerProperty.class.equals(method.getReturnType())) {
            IntegerProperty integerProperty = (IntegerProperty)value;
            if (integerProperty != null) {
                jsonObjectBuilder.add(property, integerProperty.get());
            }
        } else if (LongProperty.class.equals(method.getReturnType())) {
            LongProperty longProperty = (LongProperty)value;
            if (longProperty != null) {
                jsonObjectBuilder.add(property, longProperty.get());
            }
        } else if (StringProperty.class.equals(method.getReturnType())) {
            StringProperty stringProperty = (StringProperty)value;
            if (stringProperty != null) {
                String string = (String)stringProperty.get();
                if (string != null) {
                    jsonObjectBuilder.add(property, string);
                } else {
                    jsonObjectBuilder.addNull(property);
                }
            }
        } else if (method.getReturnType().isEnum()) {
            if (value == null) {
                jsonObjectBuilder.addNull(property);
            } else {
                jsonObjectBuilder.add(property, ((Enum)value).name());
            }
        } else if (value != null) {
            JsonConverter converter = new JsonConverter(method.getReturnType());
            jsonObjectBuilder.add(property, (JsonValue)converter.writeToJson(value));
        } else {
            jsonObjectBuilder.addNull(property);
        }
    }

    private void writeProperty(JsonArrayBuilder jsonArrayBuilder, Class<?> type, Object value) {
        if (value == null) {
            jsonArrayBuilder.addNull();
        } else if (Boolean.class.equals(type)) {
            jsonArrayBuilder.add(((Boolean)value).booleanValue());
        } else if (Byte.class.equals(type)) {
            jsonArrayBuilder.add((int)((Byte)value).byteValue());
        } else if (Double.class.equals(type)) {
            jsonArrayBuilder.add(((Double)value).doubleValue());
        } else if (Float.class.equals(type)) {
            jsonArrayBuilder.add((double)((Float)value).floatValue());
        } else if (Integer.class.equals(type)) {
            jsonArrayBuilder.add(((Integer)value).intValue());
        } else if (Long.class.equals(type)) {
            jsonArrayBuilder.add(((Long)value).longValue());
        } else if (Short.class.equals(type)) {
            jsonArrayBuilder.add((int)((Short)value).shortValue());
        } else if (String.class.equals(type)) {
            jsonArrayBuilder.add((String)value);
        } else if (BigDecimal.class.equals(type)) {
            jsonArrayBuilder.add((BigDecimal)value);
        } else if (BigInteger.class.equals(type)) {
            jsonArrayBuilder.add((BigInteger)value);
        } else {
            JsonConverter converter = new JsonConverter(type);
            jsonArrayBuilder.add((JsonValue)converter.writeToJson(value));
        }
    }

    private void writeProperty(JsonObjectBuilder jsonObjectBuilder, String key, Class<?> type, Object value) {
        if (value == null) {
            jsonObjectBuilder.addNull(key);
        } else if (Boolean.class.equals(type)) {
            jsonObjectBuilder.add(key, ((Boolean)value).booleanValue());
        } else if (Byte.class.equals(type)) {
            jsonObjectBuilder.add(key, (int)((Byte)value).byteValue());
        } else if (Double.class.equals(type)) {
            jsonObjectBuilder.add(key, ((Double)value).doubleValue());
        } else if (Float.class.equals(type)) {
            jsonObjectBuilder.add(key, (double)((Float)value).floatValue());
        } else if (Integer.class.equals(type)) {
            jsonObjectBuilder.add(key, ((Integer)value).intValue());
        } else if (Long.class.equals(type)) {
            jsonObjectBuilder.add(key, ((Long)value).longValue());
        } else if (Short.class.equals(type)) {
            jsonObjectBuilder.add(key, (int)((Short)value).shortValue());
        } else if (String.class.equals(type)) {
            jsonObjectBuilder.add(key, (String)value);
        } else if (BigDecimal.class.equals(type)) {
            jsonObjectBuilder.add(key, (BigDecimal)value);
        } else if (BigInteger.class.equals(type)) {
            jsonObjectBuilder.add(key, (BigInteger)value);
        } else {
            JsonConverter converter = new JsonConverter(type);
            jsonObjectBuilder.add(key, (JsonValue)converter.writeToJson(value));
        }
    }
}

