/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.converter;

import com.gluonhq.connect.converter.InputStreamIterableInputConverter;
import com.gluonhq.connect.converter.JsonConverter;
import com.gluonhq.impl.connect.converter.JsonUtil;
import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class JsonIterableInputConverter<E>
extends InputStreamIterableInputConverter<E>
implements Iterator<E> {
    private final Class<E> targetClass;
    private JsonArray jsonArray;
    private int index;
    private JsonConverter<E> converter;

    public JsonIterableInputConverter(Class<E> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public E next() {
        if (Boolean.class.isAssignableFrom(this.targetClass)) {
            return (E)Boolean.valueOf(this.jsonArray.getBoolean(this.index++));
        }
        if (Byte.class.isAssignableFrom(this.targetClass)) {
            return (E)Byte.valueOf(Integer.valueOf(this.jsonArray.getInt(this.index++)).byteValue());
        }
        if (Double.class.isAssignableFrom(this.targetClass)) {
            return (E)Double.valueOf(this.jsonArray.getJsonNumber(this.index++).doubleValue());
        }
        if (Float.class.isAssignableFrom(this.targetClass)) {
            return (E)Float.valueOf(Double.valueOf(this.jsonArray.getJsonNumber(this.index++).doubleValue()).floatValue());
        }
        if (Integer.class.isAssignableFrom(this.targetClass)) {
            return (E)Integer.valueOf(this.jsonArray.getInt(this.index++));
        }
        if (Long.class.isAssignableFrom(this.targetClass)) {
            return (E)Long.valueOf(this.jsonArray.getJsonNumber(this.index++).longValue());
        }
        if (Short.class.isAssignableFrom(this.targetClass)) {
            return (E)Short.valueOf(Integer.valueOf(this.jsonArray.getInt(this.index++)).shortValue());
        }
        if (String.class.isAssignableFrom(this.targetClass)) {
            return (E)this.jsonArray.getString(this.index++);
        }
        JsonObject jsonObject = this.jsonArray.getJsonObject(this.index++);
        if (JsonObject.class.isAssignableFrom(this.targetClass)) {
            return (E)jsonObject;
        }
        if (this.converter == null) {
            this.converter = new JsonConverter<E>(this.targetClass);
        }
        return this.converter.readFromJson(jsonObject);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.jsonArray.size();
    }

    @Override
    public Iterator<E> iterator() {
        this.index = 0;
        try (JsonReader reader = JsonUtil.createJsonReader(this.getInputStream());){
            this.jsonArray = reader.readArray();
        }
        return this;
    }
}

