/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.converter;

import com.gluonhq.connect.converter.JsonConverter;
import com.gluonhq.connect.converter.OutputConverter;
import com.gluonhq.connect.converter.OutputStreamOutputConverter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class JsonOutputConverter<T>
extends OutputStreamOutputConverter<T>
implements OutputConverter<T> {
    private static final Logger LOG = Logger.getLogger(JsonOutputConverter.class.getName());
    private static final JsonWriterFactory writerFactory = Json.createWriterFactory(null);
    private final JsonConverter<T> converter;

    public JsonOutputConverter(Class<T> targetClass) {
        this.converter = new JsonConverter<T>(targetClass);
    }

    @Override
    public void write(T t) {
        try (JsonWriter writer = writerFactory.createWriter(this.getOutputStream());){
            JsonObject jsonObject = JsonObject.class.isAssignableFrom(this.converter.getTargetClass()) ? (JsonObject)t : this.converter.writeToJson(t);
            if (LOG.isLoggable(Level.FINE)) {
                StringWriter stringWriter = new StringWriter();
                try (JsonWriter writer2 = writerFactory.createWriter((Writer)stringWriter);){
                    writer2.writeObject(jsonObject);
                    LOG.log(Level.FINE, "Written JSON data: " + stringWriter.toString());
                }
            }
            writer.writeObject(jsonObject);
        }
    }
}

