/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.converter;

import com.gluonhq.connect.converter.InputStreamInputConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringInputConverter
extends InputStreamInputConverter<String> {
    private static final Logger LOGGER = Logger.getLogger(StringInputConverter.class.getName());

    @Override
    public String read() {
        String string;
        StringWriter stringWriter = new StringWriter();
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInputStream()));
                 BufferedWriter writer = new BufferedWriter(stringWriter);){
                String line;
                boolean firstWrite = true;
                while ((line = reader.readLine()) != null) {
                    if (firstWrite) {
                        firstWrite = false;
                    } else {
                        writer.newLine();
                    }
                    writer.write(line);
                }
            }
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, "Something went wrong while reading string from InputStream.", ex);
                return null;
            }
        }
        stringWriter.close();
        return string;
    }
}

