/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.converter;

import com.gluonhq.connect.converter.InputStreamInputConverter;
import com.gluonhq.impl.connect.converter.ClassInspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlInputConverter<T>
extends InputStreamInputConverter<T> {
    private Class<T> clazz;
    private final ClassInspector<T> inspector;
    private String tag;

    public XmlInputConverter(Class<T> targetClass) {
        this(targetClass, null);
    }

    public XmlInputConverter(Class<T> targetClass, String tag) {
        this.clazz = targetClass;
        this.inspector = ClassInspector.resolve(targetClass);
        this.tag = tag;
    }

    @Override
    public T read() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream is = this.getInputStream();
            T answer = this.clazz.newInstance();
            Document doc = builder.parse(is);
            Node rootNode = doc.getDocumentElement();
            if (this.tag != null) {
                NodeList nodeList = doc.getElementsByTagName(this.tag);
                if (nodeList.getLength() > 0) {
                    rootNode = nodeList.item(0);
                }
                this.parseDom(rootNode.getChildNodes(), answer);
            }
            return answer;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private void parseDom(NodeList childNodes, T answer) {
        Map<String, Method> setters = this.inspector.getSetters();
        Set<String> keySet = setters.keySet();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!keySet.contains(item.getNodeName())) continue;
            try {
                Method setter = setters.get(item.getNodeName());
                Class<String> parameterType = setter.getParameterTypes()[0];
                if (!parameterType.isAssignableFrom(String.class)) continue;
                setter.invoke(answer, item.getTextContent());
                continue;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(XmlInputConverter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

