/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.source.RestDataSource;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseRestProvider {
    private static final Logger LOG = Logger.getLogger(BaseRestProvider.class.getName());
    private static final String RESPONSE_HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    protected static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    protected final RestDataSource dataSource;

    public BaseRestProvider(RestDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public RestDataSource getRestDataSource() {
        return this.dataSource;
    }

    String getContentType() {
        List<String> contentTypes;
        String contentType = null;
        Map<String, List<String>> responseHeaders = this.dataSource.getResponseHeaders();
        if (responseHeaders.containsKey(RESPONSE_HEADER_CONTENT_TYPE) && !(contentTypes = responseHeaders.get(RESPONSE_HEADER_CONTENT_TYPE)).isEmpty()) {
            contentType = contentTypes.get(0);
        }
        LOG.log(Level.FINE, "Detected Content-Type from response headers: " + contentType);
        return contentType;
    }
}

