/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.ConnectState;
import com.gluonhq.connect.GluonObservableList;
import com.gluonhq.connect.GluonObservableObject;
import com.gluonhq.connect.provider.ListDataReader;
import com.gluonhq.connect.provider.ObjectDataReader;
import com.gluonhq.connect.provider.ObjectDataRemover;
import com.gluonhq.connect.provider.ObjectDataWriter;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public class DataProvider {
    private static final Logger LOG = Logger.getLogger(DataProvider.class.getName());
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(0);
    private static ExecutorService executorService = Executors.newFixedThreadPool(5, runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("DataProviderThread-" + THREAD_NUMBER.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    });

    public static <T> GluonObservableObject<T> storeObject(T object, ObjectDataWriter<T> writer) {
        GluonObservableObject observable = writer.newGluonObservableObject();
        StackTraceElement[] callingStack = LOG.isLoggable(Level.FINE) ? Thread.currentThread().getStackTrace() : null;
        executorService.execute(() -> {
            try {
                Optional<Object> toSet = writer.writeObject(object);
                if (!observable.isInitialized()) {
                    Platform.runLater(() -> {
                        observable.set(toSet.orElse(object));
                        ((SimpleBooleanProperty)observable.initializedProperty()).set(true);
                        observable.setState(ConnectState.SUCCEEDED);
                    });
                } else {
                    Platform.runLater(() -> {
                        observable.set(toSet.orElse(object));
                        observable.setState(ConnectState.SUCCEEDED);
                    });
                }
            }
            catch (CancellationException ex) {
                Platform.runLater(() -> observable.setState(ConnectState.CANCELLED));
            }
            catch (Exception ex) {
                Platform.runLater(() -> {
                    observable.setException(callingStack != null ? DataProvider.generateFullException(callingStack, ex) : ex);
                    observable.setState(ConnectState.FAILED);
                });
            }
        });
        return observable;
    }

    public static <T> GluonObservableObject<T> retrieveObject(ObjectDataReader<T> reader) {
        GluonObservableObject observable = reader.newGluonObservableObject();
        Platform.runLater(() -> observable.setState(ConnectState.RUNNING));
        StackTraceElement[] callingStack = LOG.isLoggable(Level.FINE) ? Thread.currentThread().getStackTrace() : null;
        executorService.execute(() -> {
            try {
                Object t = reader.readObject();
                if (!observable.isInitialized()) {
                    Platform.runLater(() -> {
                        observable.set(t);
                        ((SimpleBooleanProperty)observable.initializedProperty()).set(true);
                        observable.setState(ConnectState.SUCCEEDED);
                    });
                } else {
                    Platform.runLater(() -> {
                        observable.set(t);
                        observable.setState(ConnectState.SUCCEEDED);
                    });
                }
            }
            catch (CancellationException ex) {
                Platform.runLater(() -> observable.setState(ConnectState.CANCELLED));
            }
            catch (Exception ex) {
                Platform.runLater(() -> {
                    observable.setException(callingStack != null ? DataProvider.generateFullException(callingStack, ex) : ex);
                    observable.setState(ConnectState.FAILED);
                });
            }
        });
        return observable;
    }

    public static <T> void removeObject(GluonObservableObject<T> observable, ObjectDataRemover<T> remover) {
        Platform.runLater(() -> observable.setState(ConnectState.RUNNING));
        StackTraceElement[] callingStack = LOG.isLoggable(Level.FINE) ? Thread.currentThread().getStackTrace() : null;
        executorService.execute(() -> {
            try {
                Optional t = remover.removeObject(observable);
                Platform.runLater(() -> {
                    observable.set(t.orElse(null));
                    ((SimpleObjectProperty)observable.exceptionProperty()).set(null);
                    observable.setState(ConnectState.REMOVED);
                });
            }
            catch (CancellationException ex) {
                Platform.runLater(() -> observable.setState(ConnectState.CANCELLED));
            }
            catch (Exception ex) {
                Platform.runLater(() -> {
                    observable.setException(callingStack != null ? DataProvider.generateFullException(callingStack, ex) : ex);
                    observable.setState(ConnectState.FAILED);
                });
            }
        });
    }

    public static <E> GluonObservableList<E> retrieveList(ListDataReader<E> reader) {
        GluonObservableList observable = reader.newGluonObservableList();
        Platform.runLater(() -> observable.setState(ConnectState.RUNNING));
        StackTraceElement[] callingStack = LOG.isLoggable(Level.FINE) ? Thread.currentThread().getStackTrace() : null;
        executorService.execute(() -> {
            try {
                Iterator it = reader.iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    if (e == null) continue;
                    Platform.runLater(() -> observable.add(e));
                }
                if (!observable.isInitialized()) {
                    Platform.runLater(() -> {
                        ((SimpleBooleanProperty)observable.initializedProperty()).set(true);
                        observable.setState(ConnectState.SUCCEEDED);
                    });
                } else {
                    Platform.runLater(() -> observable.setState(ConnectState.SUCCEEDED));
                }
            }
            catch (CancellationException ex) {
                Platform.runLater(() -> observable.setState(ConnectState.CANCELLED));
            }
            catch (Exception ex) {
                Platform.runLater(() -> {
                    observable.setException(callingStack != null ? DataProvider.generateFullException(callingStack, ex) : ex);
                    observable.setState(ConnectState.FAILED);
                });
            }
        });
        return observable;
    }

    private static Exception generateFullException(StackTraceElement[] callingStack, Exception cause) {
        Exception exception = new Exception(cause);
        exception.setStackTrace(callingStack);
        return exception;
    }
}

