/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.converter.InputStreamInputConverter;
import com.gluonhq.connect.converter.InputStreamIterableInputConverter;
import com.gluonhq.connect.converter.OutputStreamOutputConverter;
import com.gluonhq.connect.provider.InputStreamListDataReader;
import com.gluonhq.connect.provider.InputStreamObjectDataReader;
import com.gluonhq.connect.provider.ListDataReader;
import com.gluonhq.connect.provider.ObjectDataReader;
import com.gluonhq.connect.provider.ObjectDataRemover;
import com.gluonhq.connect.provider.ObjectDataWriter;
import com.gluonhq.connect.provider.OutputStreamObjectDataWriter;
import com.gluonhq.connect.source.FileDataSource;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class FileClient {
    private File file;

    private FileClient(File file) {
        this.file = file;
    }

    public static FileClient create(File file) {
        return new FileClient(file);
    }

    public FileDataSource createFileDataSource() {
        return new FileDataSource(this.file);
    }

    public <T> ObjectDataReader<T> createObjectDataReader(InputStreamInputConverter<T> converter) {
        return new InputStreamObjectDataReader<T>(this.createFileDataSource(), converter);
    }

    public <T> ObjectDataWriter<T> createObjectDataWriter(OutputStreamOutputConverter<T> converter) {
        return new OutputStreamObjectDataWriter<T>(this.createFileDataSource(), converter);
    }

    public <T> ObjectDataRemover<T> createObjectDataRemover() {
        return observable -> {
            if (this.file.exists() && this.file.isFile() && !this.file.delete()) {
                throw new IOException("Failed to delete file: " + this.file);
            }
            return Optional.empty();
        };
    }

    public <T> ListDataReader<T> createListDataReader(InputStreamIterableInputConverter<T> converter) {
        return new InputStreamListDataReader<T>(this.createFileDataSource(), converter);
    }
}

