/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.MultiValuedMap;
import com.gluonhq.connect.converter.InputStreamInputConverter;
import com.gluonhq.connect.converter.InputStreamIterableInputConverter;
import com.gluonhq.connect.converter.OutputStreamOutputConverter;
import com.gluonhq.connect.provider.ListDataReader;
import com.gluonhq.connect.provider.ObjectDataReader;
import com.gluonhq.connect.provider.ObjectDataRemover;
import com.gluonhq.connect.provider.ObjectDataWriter;
import com.gluonhq.connect.provider.RestListDataReader;
import com.gluonhq.connect.provider.RestObjectDataReader;
import com.gluonhq.connect.provider.RestObjectDataWriterAndRemover;
import com.gluonhq.connect.source.RestDataSource;

public class RestClient {
    private String host;
    private String path;
    private String method;
    private int readTimeout;
    private int connectTimeout;
    private String dataString;
    private String consumerKey;
    private String consumerSecret;
    private MultiValuedMap<String, String> headers = new MultiValuedMap();
    private MultiValuedMap<String, String> queryParams = new MultiValuedMap();
    private MultiValuedMap<String, String> formParams = new MultiValuedMap();
    private MultiValuedMap<String, String> multipartStringFields = new MultiValuedMap();
    private MultiValuedMap<String, byte[]> multipartByteFields = new MultiValuedMap();
    private String contentType;

    private RestClient() {
    }

    public static RestClient create() {
        return new RestClient();
    }

    public RestClient host(String host) {
        this.host = host;
        return this;
    }

    public RestClient path(String path) {
        this.path = path;
        return this;
    }

    public RestClient method(String method) {
        this.method = method;
        return this;
    }

    public RestClient readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public RestClient connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public RestClient dataString(String dataString) {
        this.dataString = dataString;
        return this;
    }

    public RestClient consumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public RestClient consumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    public RestClient queryParam(String key, String value) {
        this.queryParams.putSingle(key, value);
        return this;
    }

    public RestClient formParam(String key, String value) {
        this.formParams.putSingle(key, value);
        return this;
    }

    public RestClient contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RestClient header(String field, String value) {
        this.headers.putSingle(field, value);
        return this;
    }

    public RestClient multipartField(String field, String value) {
        this.multipartStringFields.putSingle(field, value);
        return this;
    }

    public RestClient multipartField(String field, byte[] value) {
        this.multipartByteFields.putSingle(field, value);
        return this;
    }

    public RestDataSource createRestDataSource() {
        RestDataSource dataSource = new RestDataSource();
        this.applyFields(dataSource);
        return dataSource;
    }

    public <T> ObjectDataReader<T> createObjectDataReader(Class<T> targetClass) {
        return new RestObjectDataReader<T>(this.createRestDataSource(), targetClass);
    }

    public <T> ObjectDataReader<T> createObjectDataReader(InputStreamInputConverter<T> converter) {
        return new RestObjectDataReader<T>(this.createRestDataSource(), converter);
    }

    public <T> ObjectDataWriter<T> createObjectDataWriter(Class<T> targetClass) {
        return new RestObjectDataWriterAndRemover<T>(this.createRestDataSource(), targetClass);
    }

    public <T> ObjectDataWriter<T> createObjectDataWriter(OutputStreamOutputConverter<T> outputConverter, InputStreamInputConverter<T> inputConverter) {
        return new RestObjectDataWriterAndRemover<T>(this.createRestDataSource(), outputConverter, inputConverter);
    }

    public <T> ObjectDataRemover<T> createObjectDataRemover(Class<T> targetClass) {
        return new RestObjectDataWriterAndRemover<T>(this.createRestDataSource(), targetClass);
    }

    public <T> ObjectDataRemover<T> createObjectDataRemover(OutputStreamOutputConverter<T> outputConverter, InputStreamInputConverter<T> inputConverter) {
        return new RestObjectDataWriterAndRemover<T>(this.createRestDataSource(), outputConverter, inputConverter);
    }

    public <E> ListDataReader<E> createListDataReader(Class<E> targetClass) {
        return new RestListDataReader<E>(this.createRestDataSource(), targetClass);
    }

    public <E> ListDataReader<E> createListDataReader(InputStreamIterableInputConverter<E> converter) {
        return new RestListDataReader<E>(this.createRestDataSource(), converter);
    }

    private void applyFields(RestDataSource dataSource) {
        dataSource.setHost(this.host);
        dataSource.setPath(this.path);
        dataSource.setMethod(this.method);
        dataSource.setReadTimeout(this.readTimeout);
        dataSource.setConnectTimeout(this.connectTimeout);
        dataSource.setDataString(this.dataString);
        dataSource.setConsumerKey(this.consumerKey);
        dataSource.setConsumerSecret(this.consumerSecret);
        dataSource.setQueryParams(this.queryParams);
        dataSource.setFormParams(this.formParams);
        dataSource.setMultipartStringFields(this.multipartStringFields);
        dataSource.setMultipartByteFields(this.multipartByteFields);
        dataSource.setContentType(this.contentType);
        dataSource.setHeaders(this.headers);
    }

    public String toString() {
        return "RestClient{host='" + this.host + "', path='" + this.path + "', method='" + this.method + "', readTimeout=" + this.readTimeout + ", connectTimeout=" + this.connectTimeout + ", dataString='" + this.dataString + "', consumerKey='" + this.consumerKey + "', consumerSecret='" + this.consumerSecret + "', headers=" + this.headers + ", queryParams=" + this.queryParams + ", formParams=" + this.formParams + ", multipartStringFields=" + this.multipartStringFields + ", multipartByteFields=" + this.multipartByteFields + ", contentType='" + this.contentType + "'}";
    }
}

