/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.GluonObservableList;
import com.gluonhq.connect.converter.InputStreamIterableInputConverter;
import com.gluonhq.connect.converter.JsonIterableInputConverter;
import com.gluonhq.connect.provider.BaseRestProvider;
import com.gluonhq.connect.provider.ListDataReader;
import com.gluonhq.connect.source.RestDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class RestListDataReader<E>
extends BaseRestProvider
implements ListDataReader<E> {
    private final Class<E> targetClass;
    private final InputStreamIterableInputConverter<E> inputConverter;

    public RestListDataReader(RestDataSource dataSource, Class<E> targetClass) {
        super(dataSource);
        this.targetClass = targetClass;
        this.inputConverter = null;
    }

    public RestListDataReader(RestDataSource dataSource, InputStreamIterableInputConverter<E> inputConverter) {
        super(dataSource);
        this.targetClass = null;
        this.inputConverter = inputConverter;
    }

    @Override
    public GluonObservableList<E> newGluonObservableList() {
        return new GluonObservableList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<E> iterator() throws IOException {
        InputStream inputStream = this.dataSource.getInputStream();
        InputStreamIterableInputConverter<E> converter = this.inputConverter;
        if (converter == null) {
            String contentType = this.getContentType();
            if (contentType != null) {
                if (!contentType.startsWith("application/json")) throw new IllegalStateException("Could not determine IterableInputConverter based on Content-Type: " + contentType);
                converter = new JsonIterableInputConverter<E>(this.targetClass);
            } else {
                converter = new JsonIterableInputConverter<E>(this.targetClass);
            }
        }
        converter.setInputStream(inputStream);
        return converter.iterator();
    }
}

