/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.GluonObservableObject;
import com.gluonhq.connect.converter.InputStreamInputConverter;
import com.gluonhq.connect.converter.JsonInputConverter;
import com.gluonhq.connect.converter.StringInputConverter;
import com.gluonhq.connect.converter.VoidInputConverter;
import com.gluonhq.connect.provider.BaseRestProvider;
import com.gluonhq.connect.provider.ObjectDataReader;
import com.gluonhq.connect.source.RestDataSource;
import java.io.IOException;
import java.io.InputStream;

public class RestObjectDataReader<T>
extends BaseRestProvider
implements ObjectDataReader<T> {
    protected final Class<T> targetClass;
    private final InputStreamInputConverter<T> inputConverter;

    public RestObjectDataReader(RestDataSource dataSource, Class<T> targetClass) {
        super(dataSource);
        this.targetClass = targetClass;
        this.inputConverter = null;
    }

    public RestObjectDataReader(RestDataSource dataSource, InputStreamInputConverter<T> inputConverter) {
        super(dataSource);
        this.targetClass = null;
        this.inputConverter = inputConverter;
    }

    @Override
    public GluonObservableObject<T> newGluonObservableObject() {
        return new GluonObservableObject();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public T readObject() throws IOException {
        void var2_9;
        InputStream inputStream = this.dataSource.getInputStream();
        InputStreamInputConverter<T> inputStreamInputConverter = this.inputConverter;
        if (inputStreamInputConverter == null) {
            if (this.targetClass != null && String.class.isAssignableFrom(this.targetClass)) {
                StringInputConverter stringInputConverter = new StringInputConverter();
            } else if (this.targetClass != null && Void.class.isAssignableFrom(this.targetClass)) {
                VoidInputConverter voidInputConverter = new VoidInputConverter();
            } else {
                int responseCode = this.getRestDataSource().getResponseCode();
                if (responseCode == 204) {
                    VoidInputConverter voidInputConverter = new VoidInputConverter();
                } else {
                    String contentType = this.getContentType();
                    if (contentType != null) {
                        if (contentType.startsWith("application/json")) {
                            JsonInputConverter<T> jsonInputConverter = new JsonInputConverter<T>(this.targetClass);
                        } else {
                            if (!contentType.startsWith("text/plain")) throw new IllegalStateException("Could not determine InputConverter based on Content-Type: " + contentType);
                            StringInputConverter stringInputConverter = new StringInputConverter();
                        }
                    } else {
                        JsonInputConverter<T> jsonInputConverter = new JsonInputConverter<T>(this.targetClass);
                    }
                }
            }
        }
        var2_9.setInputStream(inputStream);
        return var2_9.read();
    }
}

