/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.provider;

import com.gluonhq.connect.GluonObservableObject;
import com.gluonhq.connect.converter.InputStreamInputConverter;
import com.gluonhq.connect.converter.JsonOutputConverter;
import com.gluonhq.connect.converter.OutputStreamOutputConverter;
import com.gluonhq.connect.converter.StringOutputConverter;
import com.gluonhq.connect.converter.VoidOutputConverter;
import com.gluonhq.connect.provider.ObjectDataRemover;
import com.gluonhq.connect.provider.ObjectDataWriter;
import com.gluonhq.connect.provider.RestObjectDataReader;
import com.gluonhq.connect.source.RestDataSource;
import java.io.IOException;
import java.util.Optional;

public class RestObjectDataWriterAndRemover<T>
extends RestObjectDataReader<T>
implements ObjectDataWriter<T>,
ObjectDataRemover<T> {
    private final OutputStreamOutputConverter<T> outputConverter;

    public RestObjectDataWriterAndRemover(RestDataSource dataSource, Class<T> targetClass) {
        super(dataSource, targetClass);
        this.outputConverter = null;
    }

    public RestObjectDataWriterAndRemover(RestDataSource dataSource, OutputStreamOutputConverter<T> outputConverter, InputStreamInputConverter<T> inputConverter) {
        super(dataSource, inputConverter);
        this.outputConverter = outputConverter;
    }

    @Override
    public Optional<T> writeObject(T object) throws IOException {
        this.getOutputConverter().write(object);
        return Optional.ofNullable(this.readObject());
    }

    @Override
    public Optional<T> removeObject(GluonObservableObject<T> observable) throws IOException {
        this.getOutputConverter().write(observable.get());
        return Optional.ofNullable(this.readObject());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OutputStreamOutputConverter<T> getOutputConverter() throws IOException {
        void var1_6;
        OutputStreamOutputConverter<T> outputStreamOutputConverter = this.outputConverter;
        if (outputStreamOutputConverter == null) {
            if (this.dataSource.getContentType() != null) {
                if (!this.dataSource.getContentType().startsWith("application/json")) throw new IllegalStateException("Could not determine OutputConverter based on Content-Type: " + this.dataSource.getContentType());
                JsonOutputConverter jsonOutputConverter = new JsonOutputConverter(this.targetClass);
            } else if (this.targetClass != null && String.class.isAssignableFrom(this.targetClass)) {
                StringOutputConverter stringOutputConverter = new StringOutputConverter();
            } else if (this.targetClass != null && Void.class.isAssignableFrom(this.targetClass)) {
                VoidOutputConverter voidOutputConverter = new VoidOutputConverter();
            } else {
                JsonOutputConverter jsonOutputConverter = new JsonOutputConverter(this.targetClass);
            }
        }
        var1_6.setOutputStream(this.dataSource.getOutputStream());
        return var1_6;
    }
}

