/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.connect.source;

import com.gluonhq.connect.MultiValuedMap;
import com.gluonhq.connect.source.IODataSource;
import com.gluonhq.impl.connect.OAuth;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class RestDataSource
implements IODataSource {
    private static final Logger LOG = Logger.getLogger(RestDataSource.class.getName());
    private static final String LINE_FEED = "\r\n";
    private String host;
    private String path = "";
    private String method = null;
    private int readTimeout = -1;
    private int connectTimeout = -1;
    private String dataString;
    private String consumerKey;
    private String consumerSecret;
    private MultiValuedMap<String, String> queryParams = new MultiValuedMap();
    private MultiValuedMap<String, String> formParams = new MultiValuedMap();
    private MultiValuedMap<String, String> headers = new MultiValuedMap();
    private MultiValuedMap<String, String> multipartStringFields = new MultiValuedMap();
    private MultiValuedMap<String, byte[]> multipartByteFields = new MultiValuedMap();
    private String contentType;
    private HttpURLConnection connection;
    private Map<String, List<String>> responseHeaders;
    private int responseCode = -1;
    private String responseMessage;

    @Override
    public InputStream getInputStream() throws IOException {
        return this.createInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.createOutputStream();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path == null ? "" : (path.startsWith("/") ? path : "/" + path);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getDataString() {
        return this.dataString;
    }

    public void setDataString(String dataString) {
        this.dataString = dataString;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void addQueryParam(String key, String value) {
        this.queryParams.putSingle(key, value);
    }

    public MultiValuedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(MultiValuedMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void addFormParam(String key, String value) {
        this.formParams.putSingle(key, value);
    }

    public MultiValuedMap<String, String> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(MultiValuedMap<String, String> formParams) {
        this.formParams = formParams;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void addHeader(String field, String value) {
        this.headers.putSingle(field, value);
    }

    public MultiValuedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultiValuedMap<String, String> headers) {
        this.headers = headers;
    }

    public MultiValuedMap<String, String> getMultipartStringFields() {
        return this.multipartStringFields;
    }

    public void setMultipartStringFields(MultiValuedMap<String, String> multipartStringFields) {
        this.multipartStringFields = multipartStringFields;
    }

    public MultiValuedMap<String, byte[]> getMultipartByteFields() {
        return this.multipartByteFields;
    }

    public void setMultipartByteFields(MultiValuedMap<String, byte[]> multipartByteFields) {
        this.multipartByteFields = multipartByteFields;
    }

    private void createRequest() throws IOException {
        String urlBase;
        if (this.connection != null) {
            return;
        }
        String request = urlBase = this.host + this.path;
        String queryString = this.createQueryString();
        if (queryString != null) {
            request = request + "?" + queryString;
        }
        if (this.method == null) {
            this.method = this.formParams.isEmpty() && this.dataString == null ? "GET" : "POST";
        }
        URL url = new URL(request);
        this.connection = (HttpURLConnection)url.openConnection();
        if (this.consumerKey != null) {
            try {
                MultiValuedMap<String, String> allParams = new MultiValuedMap<String, String>();
                allParams.putAll(this.queryParams);
                allParams.putAll(this.formParams);
                String header = OAuth.getHeader(this.method, urlBase, allParams, this.consumerKey, this.consumerSecret);
                this.connection.addRequestProperty("Authorization", header);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(RestDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(RestDataSource.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.connection.setRequestMethod(this.method);
        if (this.readTimeout > -1) {
            this.connection.setReadTimeout(this.readTimeout);
        }
        if (this.connectTimeout > -1) {
            this.connection.setConnectTimeout(this.connectTimeout);
        }
        if (this.headers != null) {
            for (Map.Entry requestProperty : this.headers.entrySet()) {
                for (String value : (List)requestProperty.getValue()) {
                    this.connection.addRequestProperty((String)requestProperty.getKey(), value);
                }
            }
        }
        if (this.formParams != null && !this.formParams.isEmpty()) {
            if (this.dataString == null) {
                this.dataString = "";
            }
            for (Map.Entry entryList : this.formParams.entrySet()) {
                String key = (String)entryList.getKey();
                for (String val : (List)entryList.getValue()) {
                    if (val == null) {
                        throw new IllegalArgumentException("Values in form parameters can't be null -- was null for key " + key);
                    }
                    if (!this.dataString.isEmpty()) {
                        this.dataString = this.dataString + "&";
                    }
                    String eval = URLEncoder.encode(val, "UTF-8");
                    this.dataString = this.dataString + key + "=" + eval;
                }
            }
        }
        LOG.log(Level.FINE, "Created Rest Connection:\n\tMethod: " + this.method + "\n\tRequest URL: " + request + "\n\tForm Params: " + this.formParams + "\n\tContentType: " + this.contentType + "\n\tConsumer Credentials: " + this.consumerKey + " / " + (this.consumerSecret != null ? "********" : "null"));
    }

    private InputStream createInputStream() throws IOException {
        InputStream finalInputStream;
        this.createRequest();
        if (!this.connection.getDoOutput()) {
            if (this.dataString != null) {
                this.connection.setDoOutput(true);
                if (this.contentType == null) {
                    this.contentType = "application/x-www-form-urlencoded";
                }
                this.connection.setRequestProperty("Content-Type", this.contentType);
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.connection.getOutputStream());){
                    outputStreamWriter.write(this.dataString);
                }
            }
            if ("multipart/form-data".equals(this.contentType)) {
                this.connection.setDoOutput(true);
                String boundary = this.addMultipartBoundary(this.connection);
                try (OutputStream outputStream = this.connection.getOutputStream();
                     OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
                    this.writeMultipart(outputStream, writer, boundary);
                }
            }
        }
        if (this.connection.getResponseCode() < 400) {
            byte[] hdr;
            InputStream inputStream = this.connection.getInputStream();
            PushbackInputStream pb = new PushbackInputStream(inputStream, 2);
            int bytesRead = pb.read(hdr = new byte[2]);
            if (bytesRead >= 0) {
                pb.unread(hdr, 0, bytesRead);
            }
            finalInputStream = bytesRead == 2 && hdr[0] == 31 && hdr[1] == -117 ? new GZIPInputStream(pb) : pb;
        } else {
            finalInputStream = this.connection.getErrorStream();
        }
        this.responseHeaders = this.connection.getHeaderFields();
        this.responseCode = this.connection.getResponseCode();
        this.responseMessage = this.connection.getResponseMessage();
        return finalInputStream;
    }

    private OutputStream createOutputStream() throws IOException {
        this.createRequest();
        this.connection.setDoOutput(true);
        if (this.contentType == null) {
            this.contentType = "application/x-www-form-urlencoded";
        }
        if (this.dataString != null && "application/x-www-form-urlencoded".equals(this.contentType)) {
            this.connection.setRequestProperty("Content-Type", this.contentType);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.connection.getOutputStream());){
                outputStreamWriter.write(this.dataString);
            }
        } else if ("multipart/form-data".equals(this.contentType)) {
            String boundary = this.addMultipartBoundary(this.connection);
            OutputStream outputStream = this.connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(this.connection.getOutputStream(), "UTF-8");
            this.writeMultipart(outputStream, writer, boundary);
        } else {
            this.connection.setRequestProperty("Content-Type", this.contentType);
        }
        return this.connection.getOutputStream();
    }

    private String createQueryString() {
        if (this.queryParams.isEmpty()) {
            return null;
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : this.queryParams.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (queryString.length() == 0) {
                    queryString = new StringBuilder((String)entry.getKey()).append("=").append(value);
                    continue;
                }
                queryString.append("&").append((String)entry.getKey()).append("=").append(value);
            }
        }
        return queryString.toString();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    private String addMultipartBoundary(HttpURLConnection connection) {
        String boundary = "---" + System.currentTimeMillis();
        connection.setRequestProperty("Content-Type", this.contentType + "; boundary=" + boundary);
        return boundary;
    }

    private void writeMultipart(OutputStream outputStream, Writer writer, String boundary) throws IOException {
        for (Map.Entry entry : this.multipartStringFields.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                this.addMultipartFormField(boundary, writer, (String)entry.getKey(), (String)value);
            }
        }
        for (Map.Entry entry : this.multipartByteFields.entrySet()) {
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                Object value;
                value = (byte[])iterator.next();
                this.addMultipartFormField(boundary, writer, outputStream, (String)entry.getKey(), (byte[])value);
            }
        }
        writer.append(LINE_FEED).flush();
        writer.append("--").append(boundary).append("--").append(LINE_FEED);
    }

    private void addMultipartFormField(String boundary, Writer writer, String name, String value) throws IOException {
        writer.append("--").append(boundary).append(LINE_FEED).append("Content-Disposition: form-data; name=\"").append(name).append("\"").append(LINE_FEED).append("Content-Type: text/plain; charset=UTF-8").append(LINE_FEED).append(LINE_FEED).append(value).append(LINE_FEED);
        writer.flush();
    }

    private void addMultipartFormField(String boundary, Writer writer, OutputStream os, String name, byte[] value) throws IOException {
        writer.append("--").append(boundary).append(LINE_FEED).append("Content-Disposition: form-data; name=\"").append(name).append("\"; filename=\"raw\"").append(LINE_FEED).append("Content-Type: application/octet-stream").append(LINE_FEED).append("Content-Transfer-Encoding: binary").append(LINE_FEED).append(LINE_FEED);
        writer.flush();
        os.write(value);
        os.flush();
        writer.append(LINE_FEED);
        writer.flush();
    }
}

