/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.connect.converter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ClassInspector<T> {
    private static final Map<Class<?>, ClassInspector<?>> inspectors = new HashMap();
    private final Map<Class<?>, Map<String, Method>> inspectedGetters = new HashMap();
    private final Map<Class<?>, Map<String, Method>> inspectedSetters = new HashMap();
    private final Class<T> targetClass;

    public static synchronized <T> ClassInspector<T> resolve(Class<T> targetClass) {
        if (inspectors.containsKey(targetClass)) {
            return inspectors.get(targetClass);
        }
        ClassInspector<T> inspector = new ClassInspector<T>(targetClass);
        inspectors.put(targetClass, inspector);
        return inspector;
    }

    private ClassInspector(Class<T> targetClass) {
        this.targetClass = targetClass;
        this.resolveProperties();
    }

    public Map<String, Method> getGetters() {
        return this.inspectedGetters.get(this.targetClass);
    }

    public Map<String, Method> getSetters() {
        return this.inspectedSetters.get(this.targetClass);
    }

    private void resolveProperties() {
        if (this.inspectedSetters.containsKey(this.targetClass)) {
            return;
        }
        HashMap<Object, Method> gettersMappedByPropertyName = new HashMap<Object, Method>();
        HashMap<Object, Method> settersMappedByPropertyName = new HashMap<Object, Method>();
        this.inspectedGetters.put(this.targetClass, gettersMappedByPropertyName);
        this.inspectedSetters.put(this.targetClass, settersMappedByPropertyName);
        Method[] methods = this.targetClass.getMethods();
        Arrays.sort(methods, (m1, m2) -> m1.getName().compareTo(m2.getName()));
        HashMap<String, Method> getters = new HashMap<String, Method>();
        for (Method method : methods) {
            XmlElement xmlElement;
            String annotatedName;
            Method getter;
            String bareMethodName;
            String methodName = method.getName();
            if (Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.isAnnotationPresent(XmlTransient.class) && (methodName.matches("^get[A-Z].*") && !method.getReturnType().equals(Void.TYPE) || methodName.matches("^is[A-Z].*") && method.getReturnType().equals(Boolean.TYPE))) {
                bareMethodName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                getters.put(bareMethodName, method);
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) || method.isAnnotationPresent(XmlTransient.class) || !methodName.matches("^set[A-Z].*") || (getter = (Method)getters.get(bareMethodName = methodName.substring(3))) == null) continue;
            Object finalName = bareMethodName.substring(0, 1).toLowerCase(Locale.ROOT);
            if (bareMethodName.length() > 1) {
                finalName = (String)finalName + bareMethodName.substring(1);
            }
            if ((getter.isAnnotationPresent(XmlElement.class) || method.isAnnotationPresent(XmlElement.class)) && (annotatedName = (xmlElement = getter.isAnnotationPresent(XmlElement.class) ? getter.getAnnotation(XmlElement.class) : method.getAnnotation(XmlElement.class)).name()) != null && !annotatedName.isEmpty()) {
                finalName = annotatedName;
            }
            gettersMappedByPropertyName.put(finalName, getter);
            settersMappedByPropertyName.put(finalName, method);
        }
    }
}

