/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.connect.event;

import com.gluonhq.impl.connect.event.ConnectEventHandler;
import java.util.HashMap;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventType;

public class ConnectEventDispatcher<T extends Event>
implements EventDispatcher {
    private final Map<EventType<T>, ConnectEventHandler<T>> eventHandlerMap;
    private final Object eventSource;

    public ConnectEventDispatcher(Object eventSource) {
        this.eventSource = eventSource;
        this.eventHandlerMap = new HashMap<EventType<T>, ConnectEventHandler<T>>();
    }

    public Event dispatchEvent(Event event, EventDispatchChain tail) {
        if ((event = this.dispatchCapturingEvent(event)).isConsumed()) {
            return null;
        }
        if ((event = tail.dispatchEvent(event)) != null && (event = this.dispatchBubblingEvent(event)).isConsumed()) {
            return null;
        }
        return event;
    }

    public final void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        ConnectEventDispatcher.validateEventType(eventType);
        ConnectEventHandler<? super T> dialogEventHandler = this.eventHandlerMap.get(eventType);
        if (dialogEventHandler == null) {
            if (eventHandler == null) {
                return;
            }
            dialogEventHandler = new ConnectEventHandler();
            this.eventHandlerMap.put(eventType, dialogEventHandler);
        }
        dialogEventHandler.setEventHandler(eventHandler);
    }

    public final Event dispatchCapturingEvent(T event) {
        EventType eventType = event.getEventType();
        do {
            event = this.dispatchCapturingEvent(eventType, event);
        } while ((eventType = eventType.getSuperType()) != null);
        return event;
    }

    public final Event dispatchBubblingEvent(T event) {
        EventType eventType = event.getEventType();
        do {
            event = this.dispatchBubblingEvent(eventType, event);
        } while ((eventType = eventType.getSuperType()) != null);
        return event;
    }

    private T dispatchCapturingEvent(EventType<T> handlerType, T event) {
        ConnectEventHandler<T> compositeEventHandler = this.eventHandlerMap.get(handlerType);
        if (compositeEventHandler != null) {
            event = this.fixEventSource(event, this.eventSource);
            compositeEventHandler.dispatchCapturingEvent((Event)event);
        }
        return event;
    }

    private T dispatchBubblingEvent(EventType<T> handlerType, T event) {
        ConnectEventHandler<T> compositeEventHandler = this.eventHandlerMap.get(handlerType);
        if (compositeEventHandler != null) {
            event = this.fixEventSource(event, this.eventSource);
            compositeEventHandler.dispatchBubblingEvent((Event)event);
        }
        return event;
    }

    private T fixEventSource(T event, Object eventSource) {
        return (T)(event.getSource() != eventSource ? event.copyFor(eventSource, event.getTarget()) : event);
    }

    private static void validateEventType(EventType<?> eventType) {
        if (eventType == null) {
            throw new NullPointerException("Event type must not be null");
        }
    }
}

